/*
 * Decompiled with CFR 0.152.
 */
package shaded.channel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.channel.Channel;
import shaded.channel.CodeReader;

public class ChannelDispatcher<O>
extends Channel<O> {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelDispatcher.class);
    private final boolean failIfNoChannelToConsumeOneCharacter;
    private final Channel<O>[] channels;

    @Deprecated
    public ChannelDispatcher(List<Channel> channels) {
        this(channels, false);
    }

    @Deprecated
    public ChannelDispatcher(Channel ... channels) {
        this(Arrays.asList(channels), false);
    }

    @Deprecated
    public ChannelDispatcher(List<Channel> channels, boolean failIfNoChannelToConsumeOneCharacter) {
        this.channels = channels.toArray(new Channel[channels.size()]);
        this.failIfNoChannelToConsumeOneCharacter = failIfNoChannelToConsumeOneCharacter;
    }

    private ChannelDispatcher(Builder builder) {
        this.channels = builder.channels.toArray(new Channel[builder.channels.size()]);
        this.failIfNoChannelToConsumeOneCharacter = builder.failIfNoChannelToConsumeOneCharacter;
    }

    @Override
    public boolean consume(CodeReader code, O output) {
        int nextChar = code.peek();
        while (nextChar != -1) {
            boolean characterConsumed = false;
            for (Channel<O> channel : this.channels) {
                if (!channel.consume(code, output)) continue;
                characterConsumed = true;
                break;
            }
            if (!characterConsumed) {
                if (LOG.isDebugEnabled() || this.failIfNoChannelToConsumeOneCharacter) {
                    String message = "None of the channel has been able to handle character '" + (char)code.peek() + "' (decimal value " + code.peek() + ") at line " + code.getLinePosition() + ", column " + code.getColumnPosition();
                    if (this.failIfNoChannelToConsumeOneCharacter) {
                        throw new IllegalStateException(message);
                    }
                    LOG.debug(message);
                }
                code.pop();
            }
            nextChar = code.peek();
        }
        return true;
    }

    Channel[] getChannels() {
        return this.channels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Channel> channels = new ArrayList<Channel>();
        private boolean failIfNoChannelToConsumeOneCharacter = false;

        private Builder() {
        }

        public Builder addChannel(Channel channel) {
            this.channels.add(channel);
            return this;
        }

        public Builder addChannels(Channel ... c) {
            for (Channel channel : c) {
                this.addChannel(channel);
            }
            return this;
        }

        public Builder failIfNoChannelToConsumeOneCharacter() {
            this.failIfNoChannelToConsumeOneCharacter = true;
            return this;
        }

        public <O> ChannelDispatcher<O> build() {
            return new ChannelDispatcher(this);
        }
    }
}

