/*
 * Decompiled with CFR 0.152.
 */
package shaded.channel;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import shaded.channel.ChannelException;
import shaded.channel.CodeReaderConfiguration;
import shaded.channel.CodeReaderFilter;
import shaded.io.IOUtils;

public class CodeBuffer
implements CharSequence {
    private int lastChar = -1;
    private Cursor cursor;
    private char[] buffer;
    private int bufferPosition = 0;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private int tabWidth;
    private boolean recordingMode = false;
    private StringBuilder recordedCharacters = new StringBuilder();

    protected CodeBuffer(String code, CodeReaderConfiguration configuration) {
        this(new StringReader(code), configuration);
    }

    protected CodeBuffer(Reader initialCodeReader, CodeReaderConfiguration configuration) {
        Reader reader = null;
        try {
            this.lastChar = -1;
            this.cursor = new Cursor();
            this.tabWidth = configuration.getTabWidth();
            reader = initialCodeReader;
            for (CodeReaderFilter codeReaderFilter : configuration.getCodeReaderFilters()) {
                reader = new Filter(reader, codeReaderFilter, configuration);
            }
            this.buffer = IOUtils.toCharArray(reader);
        }
        catch (IOException e) {
            try {
                throw new ChannelException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
    }

    public final int pop() {
        if (this.bufferPosition >= this.buffer.length) {
            return -1;
        }
        int character = this.buffer[this.bufferPosition++];
        this.updateCursorPosition(character);
        if (this.recordingMode) {
            this.recordedCharacters.append((char)character);
        }
        this.lastChar = character;
        return character;
    }

    private void updateCursorPosition(int character) {
        if (character == 10 || character == 13 && this.peek() != 10) {
            this.cursor.line++;
            this.cursor.column = 0;
        } else if (character == 9) {
            this.cursor.column += this.tabWidth;
        } else {
            this.cursor.column++;
        }
    }

    public final int lastChar() {
        return this.lastChar;
    }

    public final int peek() {
        return this.intAt(0);
    }

    public final int getLinePosition() {
        return this.cursor.line;
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final int getColumnPosition() {
        return this.cursor.column;
    }

    public final CodeBuffer setColumnPosition(int cp) {
        this.cursor.column = cp;
        return this;
    }

    public final void setLinePosition(int lp) {
        this.cursor.line = lp;
    }

    public final void startRecording() {
        this.recordingMode = true;
    }

    public final CharSequence stopRecording() {
        this.recordingMode = false;
        StringBuilder result = this.recordedCharacters;
        this.recordedCharacters = new StringBuilder();
        return result;
    }

    @Override
    public final char charAt(int index) {
        return (char)this.intAt(index);
    }

    protected final int intAt(int index) {
        if (this.bufferPosition + index >= this.buffer.length) {
            return -1;
        }
        return this.buffer[this.bufferPosition + index];
    }

    @Override
    public final int length() {
        return this.buffer.length - this.bufferPosition;
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CodeReader(");
        result.append("line:").append(this.cursor.line);
        result.append("|column:").append(this.cursor.column);
        result.append("|cursor value:'").append((char)this.peek()).append("'");
        result.append(")");
        return result.toString();
    }

    static final class Filter
    extends FilterReader {
        private CodeReaderFilter<?> codeReaderFilter;

        public Filter(Reader in, CodeReaderFilter<?> codeReaderFilter, CodeReaderConfiguration configuration) {
            super(in);
            this.codeReaderFilter = codeReaderFilter;
            this.codeReaderFilter.setConfiguration(configuration.cloneWithoutCodeReaderFilters());
            this.codeReaderFilter.setReader(in);
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int read = this.codeReaderFilter.read(cbuf, off, len);
            return read == 0 ? -1 : read;
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public final class Cursor
    implements Cloneable {
        private int line = 1;
        private int column = 0;

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public Cursor clone() {
            Cursor clone = new Cursor();
            clone.column = this.column;
            clone.line = this.line;
            return clone;
        }
    }
}

