/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Archive {
    @StaticConstant
    public static final Set<String> ARCHIVE_EXTENSION_SET;

    public static boolean isArchiveFileName(String fileName) {
        String extension = Archive.getExtension(fileName);
        return ARCHIVE_EXTENSION_SET.contains(extension);
    }

    private static String getExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return fileName;
        }
        String extension = fileName.substring(lastDot).toLowerCase(Locale.ENGLISH);
        return extension;
    }

    public static boolean isLibraryFileName(String fileName) {
        String extension = Archive.getExtension(fileName);
        return ".jar".equals(extension);
    }

    static {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(".jar");
        extensions.add(".zip");
        extensions.add(".war");
        extensions.add(".ear");
        extensions.add(".sar");
        ARCHIVE_EXTENSION_SET = Collections.unmodifiableSet(extensions);
    }
}

