/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.ComponentPlugin;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.InterproceduralFirstPassDetector;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginDoesntContainMetadataException;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.PropertyBundle;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TrainingDetector;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.bugReporter.BugReporterDecorator;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.classfile.IAnalysisEngineRegistrar;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.plan.ByInterfaceDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorFactorySelector;
import edu.umd.cs.findbugs.plan.DetectorOrderingConstraint;
import edu.umd.cs.findbugs.plan.ReportingDetectorFactorySelector;
import edu.umd.cs.findbugs.plan.SingleDetectorFactorySelector;
import edu.umd.cs.findbugs.plugins.DuplicatePluginIdError;
import edu.umd.cs.findbugs.plugins.DuplicatePluginIdException;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.JavaWebStart;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.xml.XMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    private static final String XPATH_PLUGIN_SHORT_DESCRIPTION = "/MessageCollection/Plugin/ShortDescription";
    private static final String XPATH_PLUGIN_WEBSITE = "/FindbugsPlugin/@website";
    private static final String XPATH_PLUGIN_PROVIDER = "/FindbugsPlugin/@provider";
    private static final String XPATH_PLUGIN_PLUGINID = "/FindbugsPlugin/@pluginid";
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    static boolean lazyInitialization = false;
    static LinkedList<PluginLoader> partiallyInitialized = new LinkedList();
    private static int nextUnknownId;
    private ClassLoader classLoader;
    private final ClassLoader classLoaderForResources;
    private final Plugin plugin;
    private final boolean corePlugin;
    boolean initialPlugin;
    boolean cannotDisable;
    private boolean optionalPlugin;
    private final URL loadedFrom;
    private final String jarName;
    private final URI loadedFromUri;
    String parentId;
    static HashSet<String> loadedPluginIds;

    @Deprecated
    public PluginLoader(URL url) throws PluginException {
        this(url, PluginLoader.toUri(url), null, false, true);
    }

    @Deprecated
    public PluginLoader(URL url, ClassLoader parent) throws PluginException {
        this(url, PluginLoader.toUri(url), parent, false, true);
    }

    public boolean hasParent() {
        return this.parentId != null && this.parentId.length() > 0;
    }

    private PluginLoader(@Nonnull URL url, URI uri, ClassLoader parent, boolean isInitial, boolean optional) throws PluginException {
        URL[] loaderURLs = PluginLoader.createClassloaderUrls(url);
        this.classLoaderForResources = new URLClassLoader(loaderURLs);
        this.loadedFrom = url;
        this.loadedFromUri = uri;
        this.jarName = PluginLoader.getJarName(url);
        this.corePlugin = false;
        this.initialPlugin = isInitial;
        this.optionalPlugin = optional;
        this.plugin = this.init();
        if (!this.hasParent()) {
            this.classLoader = new URLClassLoader(loaderURLs, parent);
        } else {
            if (parent != PluginLoader.class.getClassLoader()) {
                throw new IllegalArgumentException("Can't specify parentid " + this.parentId + " and provide a separate class loader");
            }
            Plugin parentPlugin = Plugin.getByPluginId(this.parentId);
            if (parentPlugin != null) {
                parent = parentPlugin.getClassLoader();
                this.classLoader = new URLClassLoader(loaderURLs, parent);
            }
        }
        if (this.classLoader == null) {
            if (!lazyInitialization) {
                throw new IllegalStateException("Can't find parent plugin " + this.parentId);
            }
            partiallyInitialized.add(this);
        } else {
            this.loadPluginComponents();
            Plugin.putPlugin(this.loadedFromUri, this.plugin);
        }
    }

    private static void finishLazyInitialization() {
        if (!lazyInitialization) {
            throw new IllegalStateException("Not in lazy initialization mode");
        }
        while (!partiallyInitialized.isEmpty()) {
            boolean changed = false;
            LinkedList<String> unresolved = new LinkedList<String>();
            TreeSet<String> needed = new TreeSet<String>();
            Iterator i = partiallyInitialized.iterator();
            while (i.hasNext()) {
                PluginLoader pluginLoader = (PluginLoader)i.next();
                String pluginId = pluginLoader.getPlugin().getPluginId();
                assert (pluginLoader.hasParent());
                String parentid = pluginLoader.parentId;
                Plugin parent = Plugin.getByPluginId(parentid);
                if (parent != null) {
                    i.remove();
                    try {
                        URL[] loaderURLs = PluginLoader.createClassloaderUrls(pluginLoader.loadedFrom);
                        pluginLoader.classLoader = new URLClassLoader(loaderURLs, parent.getClassLoader());
                        pluginLoader.loadPluginComponents();
                        Plugin.putPlugin(pluginLoader.loadedFromUri, pluginLoader.plugin);
                    }
                    catch (PluginException e) {
                        throw new RuntimeException("Unable to load plugin " + pluginId, e);
                    }
                    changed = true;
                    continue;
                }
                unresolved.add(pluginId);
                needed.add(parentid);
            }
            if (changed) continue;
            String msg = "Unable to load parent plugins " + needed + " in order to load " + unresolved;
            System.err.println(msg);
            AnalysisContext.logError(msg);
            msg = "Available plugins are " + Plugin.getAllPluginIds();
            System.err.println(msg);
            AnalysisContext.logError(msg);
            for (PluginLoader pluginLoader : partiallyInitialized) {
                Plugin.removePlugin(pluginLoader.loadedFromUri);
            }
            partiallyInitialized.clear();
        }
        lazyInitialization = false;
    }

    @Nonnull
    private static URL[] createClassloaderUrls(@Nonnull URL url) throws PluginException {
        Manifest mf;
        ArrayList<URL> urls;
        block12: {
            File f;
            block13: {
                urls = new ArrayList<URL>();
                urls.add(url);
                mf = null;
                f = new File(url.getPath());
                if (f.isDirectory()) break block13;
                JarInputStream jis = null;
                try {
                    jis = new JarInputStream(url.openStream());
                    mf = jis.getManifest();
                }
                catch (IOException ioe) {
                    try {
                        throw new PluginException("Failed loading manifest for plugin jar: " + url, ioe);
                    }
                    catch (Throwable throwable) {
                        IO.close(jis);
                        throw throwable;
                    }
                }
                IO.close(jis);
                break block12;
            }
            File manifest = PluginLoader.guessManifest(f);
            if (manifest != null) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(manifest);
                    mf = new Manifest(is);
                }
                catch (IOException e) {
                    try {
                        throw new PluginException("Failed loading manifest for plugin jar: " + url, e);
                    }
                    catch (Throwable throwable) {
                        IO.close(is);
                        throw throwable;
                    }
                }
                IO.close(is);
            }
        }
        if (mf != null) {
            try {
                PluginLoader.addClassPathFromManifest(url, urls, mf);
            }
            catch (MalformedURLException e) {
                throw new PluginException("Failed loading manifest for plugin jar: " + url, e);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addClassPathFromManifest(@Nonnull URL url, @Nonnull List<URL> urls, @Nonnull Manifest mf) throws MalformedURLException {
        Attributes atts = mf.getMainAttributes();
        if (atts == null) {
            return;
        }
        String classPath = atts.getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            String[] jars;
            String jarRoot = url.toString();
            jarRoot = jarRoot.substring(0, jarRoot.lastIndexOf(47) + 1);
            for (String jar : jars = classPath.split(",")) {
                jar = jarRoot + jar.trim();
                urls.add(new URL(jar));
            }
        }
    }

    @CheckForNull
    private static File guessManifest(@Nonnull File parent) {
        File file = new File(parent, "MANIFEST.MF");
        if (!file.isFile()) {
            file = new File(parent, "META-INF/MANIFEST.MF");
        }
        if (!file.isFile()) {
            file = new File(parent, "../META-INF/MANIFEST.MF");
        }
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    @Deprecated
    public PluginLoader() throws PluginException {
        this.classLoaderForResources = this.classLoader = this.getClass().getClassLoader();
        this.corePlugin = true;
        this.initialPlugin = true;
        this.optionalPlugin = false;
        this.loadedFrom = PluginLoader.computeCoreUrl();
        try {
            this.loadedFromUri = this.loadedFrom.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse uri: " + this.loadedFrom);
        }
        this.jarName = PluginLoader.getJarName(this.loadedFrom);
        this.plugin = this.init();
        this.loadPluginComponents();
        Plugin.putPlugin(null, this.plugin);
    }

    @Deprecated
    public PluginLoader(boolean fake, URL url) {
        this.classLoaderForResources = this.classLoader = this.getClass().getClassLoader();
        this.corePlugin = false;
        this.initialPlugin = true;
        this.optionalPlugin = false;
        this.loadedFrom = url;
        try {
            this.loadedFromUri = this.loadedFrom.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse uri: " + this.loadedFrom);
        }
        this.jarName = PluginLoader.getJarName(this.loadedFrom);
        this.plugin = null;
    }

    @Nonnull
    private static URL computeCoreUrl() {
        URL from;
        block5: {
            String findBugsClassFile = ClassName.toSlashedClassName(FindBugs.class) + ".class";
            URL me = FindBugs.class.getClassLoader().getResource(findBugsClassFile);
            LOG.debug("FindBugs.class loaded from {}", (Object)me);
            if (me == null) {
                throw new IllegalStateException("Failed to load " + findBugsClassFile);
            }
            try {
                String u = me.toString();
                if (u.startsWith("jar:") && u.endsWith("!/" + findBugsClassFile)) {
                    u = u.substring(4, u.indexOf("!/"));
                    from = new URL(u);
                    break block5;
                }
                if (u.endsWith(findBugsClassFile)) {
                    u = u.substring(0, u.indexOf(findBugsClassFile));
                    from = new URL(u);
                    break block5;
                }
                throw new IllegalArgumentException("Unknown url shema: " + u);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to parse url: " + me);
            }
        }
        LOG.debug("Core class files loaded from {}", (Object)from);
        return from;
    }

    public URL getURL() {
        return this.loadedFrom;
    }

    public URI getURI() {
        return this.loadedFromUri;
    }

    private static URI toUri(URL url) throws PluginException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new PluginException("Bad uri: " + url, e);
        }
    }

    private static String getJarName(URL url) {
        String location = url.getPath();
        int i = location.lastIndexOf(47);
        location = location.substring(i + 1);
        return location;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new IllegalStateException("Plugin not completely initialized; classloader not set yet");
        }
        return this.classLoader;
    }

    public Plugin loadPlugin() throws PluginException {
        return this.getPlugin();
    }

    public Plugin getPlugin() {
        if (this.plugin == null) {
            throw new AssertionError((Object)"plugin not already loaded");
        }
        return this.plugin;
    }

    private static URL resourceFromPlugin(URL u, String args) throws MalformedURLException {
        String path = u.getPath();
        if (path.endsWith(".zip") || path.endsWith(".jar")) {
            return new URL("jar:" + u.toString() + "!/" + args);
        }
        if (path.endsWith("/")) {
            return new URL(u.toString() + args);
        }
        return new URL(u.toString() + "/" + args);
    }

    public URL getResource(String name) {
        URL url;
        if (this.isCorePlugin() && (url = PluginLoader.getCoreResource(name)) != null && IO.verifyURL(url)) {
            return url;
        }
        if (this.loadedFrom != null) {
            try {
                url = PluginLoader.resourceFromPlugin(this.loadedFrom, name);
                LOG.debug("Trying to load {} from {}", (Object)name, (Object)url);
                if (IO.verifyURL(url)) {
                    return url;
                }
            }
            catch (MalformedURLException url2) {
                // empty catch block
            }
        }
        if (this.classLoaderForResources instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)this.classLoaderForResources;
            LOG.debug("Trying to load {} using URLClassLoader.findResource", (Object)name);
            LOG.debug("  from urls: {}", Arrays.asList(urlClassLoader.getURLs()));
            URL url3 = urlClassLoader.findResource(name);
            if (url3 == null) {
                url3 = urlClassLoader.findResource("/" + name);
            }
            if (IO.verifyURL(url3)) {
                return url3;
            }
        }
        LOG.debug("Trying to load {} using ClassLoader.getResource", (Object)name);
        url = this.classLoaderForResources.getResource(name);
        if (url == null) {
            url = this.classLoaderForResources.getResource("/" + name);
        }
        if (IO.verifyURL(url)) {
            return url;
        }
        return null;
    }

    @CheckForNull
    static URL getCoreResource(String name) {
        URL u = PluginLoader.loadFromFindBugsPluginDir(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.loadFromFindBugsEtcDir(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.resourceFromFindbugsJar(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.class.getResource(name);
        if (u != null) {
            return u;
        }
        u = PluginLoader.class.getResource("/" + name);
        return u;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private static URL resourceFromFindbugsJar(String slashedResourceName) {
        try {
            URL findbugsJar = PluginLoader.getFindbugsJar();
            if (findbugsJar == null) {
                return null;
            }
            assert (findbugsJar.getProtocol().equals("file"));
            try (ZipFile jarFile = new ZipFile(new File(findbugsJar.toURI()));){
                ZipEntry entry = jarFile.getEntry(slashedResourceName);
                if (entry == null) return null;
                URL uRL = PluginLoader.resourceFromPlugin(findbugsJar, slashedResourceName);
                return uRL;
            }
            catch (ZipException e) {
                LOG.warn("Failed to load resourceFromFindbugsJar: {} is not valid zip file.", (Object)findbugsJar, (Object)e);
                return null;
            }
            catch (IOException e) {
                LOG.warn("Failed to load resourceFromFindbugsJar: IOException was thrown at zip file {} loading.", (Object)findbugsJar, (Object)e);
                return null;
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.warn("Failed to load resourceFromFindbugsJar: Resource name is {}", (Object)slashedResourceName, (Object)e);
        }
        return null;
    }

    @CheckForNull
    private static URL getFindbugsJar() throws MalformedURLException {
        String findBugsClassFile = ClassName.toSlashedClassName(FindBugs.class) + ".class";
        URL me = FindBugs.class.getClassLoader().getResource(findBugsClassFile);
        if (me == null) {
            return null;
        }
        if (!"jar".equals(me.getProtocol())) {
            return null;
        }
        String u = me.toString();
        String jarPath = u.substring(4, u.indexOf("!/"));
        return new URL(jarPath);
    }

    @CheckForNull
    public static URL loadFromFindBugsEtcDir(String name) {
        File f;
        String findBugsHome = DetectorFactoryCollection.getFindBugsHome();
        if (findBugsHome != null && (f = new File(new File(new File(findBugsHome), "etc"), name)).canRead()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    public static URL loadFromFindBugsPluginDir(String name) {
        File f;
        String findBugsHome = DetectorFactoryCollection.getFindBugsHome();
        if (findBugsHome != null && (f = new File(new File(new File(findBugsHome), "plugin"), name)).canRead()) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static <T> Class<? extends T> getClass(ClassLoader loader, @DottedClassName String className, Class<T> type) throws PluginException {
        try {
            return loader.loadClass(className).asSubclass(type);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Unable to load " + className, e);
        }
        catch (ClassCastException e) {
            throw new PluginException("Cannot cast " + className + " to " + type.getName(), e);
        }
    }

    private Plugin init() throws PluginException {
        LOG.debug("Loading plugin from {}", (Object)this.loadedFrom);
        Document pluginDescriptor = this.getPluginDescriptor();
        List<Document> messageCollectionList = this.getMessageDocuments();
        Plugin constructedPlugin = this.constructMinimalPlugin(pluginDescriptor, messageCollectionList);
        LOG.debug("Loaded {} from {}", (Object)constructedPlugin.getPluginId(), (Object)this.loadedFrom);
        return constructedPlugin;
    }

    private void loadPluginComponents() throws PluginException {
        Document pluginDescriptor = this.getPluginDescriptor();
        List<Document> messageCollectionList = this.getMessageDocuments();
        try {
            String description;
            List<Object> componentNodeList = XMLUtil.selectNodes((Node)pluginDescriptor, "/FindbugsPlugin/PluginComponent");
            for (Object componentNode : componentNodeList) {
                String string = componentNode.valueOf("@componentKind");
                if (string == null) {
                    throw new PluginException("Missing @componentKind for " + this.plugin.getPluginId() + " loaded from " + this.loadedFrom);
                }
                String componentClassname = componentNode.valueOf("@componentClass");
                if (componentClassname == null) {
                    throw new PluginException("Missing @componentClassname for " + this.plugin.getPluginId() + " loaded from " + this.loadedFrom);
                }
                String componentId = componentNode.valueOf("@id");
                if (componentId == null) {
                    throw new PluginException("Missing @id for " + this.plugin.getPluginId() + " loaded from " + this.loadedFrom);
                }
                try {
                    String propertiesLocation = componentNode.valueOf("@properties");
                    boolean disabled = Boolean.valueOf(componentNode.valueOf("@disabled"));
                    Node filterMessageNode = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/PluginComponent[@id='" + componentId + "']", "Missing Cloud description for PluginComponent " + componentId);
                    description = PluginLoader.getChildText(filterMessageNode, "Description").trim();
                    String details = PluginLoader.getChildText(filterMessageNode, "Details").trim();
                    PropertyBundle properties = new PropertyBundle();
                    if (propertiesLocation != null && propertiesLocation.length() > 0) {
                        URL properiesURL = this.classLoaderForResources.getResource(propertiesLocation);
                        if (properiesURL == null) {
                            AnalysisContext.logError("Could not load properties for " + this.plugin.getPluginId() + " component " + componentId + " from " + propertiesLocation);
                            continue;
                        }
                        properties.loadPropertiesFromURL(properiesURL);
                    }
                    List<Node> propertyNodes = XMLUtil.selectNodes((Node)componentNode, "Property");
                    for (Node node : propertyNodes) {
                        String key = node.valueOf("@key");
                        String value = node.getText();
                        properties.setProperty(key, value);
                    }
                    Class<?> componentKind = this.classLoader.loadClass(string);
                    this.loadComponentPlugin(this.plugin, componentKind, componentClassname, componentId, disabled, description, details, properties);
                }
                catch (RuntimeException e) {
                    AnalysisContext.logError("Unable to load ComponentPlugin " + componentId + " : " + componentClassname + " implementing " + string, e);
                }
            }
            if (!FindBugs.isNoMains()) {
                List<Node> findBugsMainList = XMLUtil.selectNodes((Node)pluginDescriptor, "/FindbugsPlugin/FindBugsMain");
                for (Node node : findBugsMainList) {
                    String className = node.valueOf("@class");
                    if (className == null) {
                        throw new PluginException("Missing @class for FindBugsMain in plugin" + this.plugin.getPluginId() + " loaded from " + this.loadedFrom);
                    }
                    String cmd = node.valueOf("@cmd");
                    if (cmd == null) {
                        throw new PluginException("Missing @cmd for for FindBugsMain in plugin " + this.plugin.getPluginId() + " loaded from " + this.loadedFrom);
                    }
                    String kind = node.valueOf("@kind");
                    boolean analysis = Boolean.valueOf(node.valueOf("@analysis"));
                    Element mainMessageNode = (Element)PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/FindBugsMain[@cmd='" + cmd + "']/Description", "Missing FindBugsMain description for cmd " + cmd);
                    description = mainMessageNode.getTextTrim();
                    try {
                        Class<?> mainClass = this.classLoader.loadClass(className);
                        this.plugin.addFindBugsMain(mainClass, cmd, description, kind, analysis);
                    }
                    catch (Exception e) {
                        String msg = "Unable to load FindBugsMain " + cmd + " : " + className + " in plugin " + this.plugin.getPluginId() + " loaded from " + this.loadedFrom;
                        PluginException e2 = new PluginException(msg, e);
                        AnalysisContext.logError(msg, e2);
                    }
                }
            }
            List<Node> detectorNodeList = XMLUtil.selectNodes((Node)pluginDescriptor, "/FindbugsPlugin/Detector");
            int detectorCount = 0;
            for (Node detectorNode : detectorNodeList) {
                String className = detectorNode.valueOf("@class");
                String speed = detectorNode.valueOf("@speed");
                String disabled = detectorNode.valueOf("@disabled");
                String reports = detectorNode.valueOf("@reports");
                String requireJRE = detectorNode.valueOf("@requirejre");
                String hidden = detectorNode.valueOf("@hidden");
                if (speed == null || speed.length() == 0) {
                    speed = "fast";
                }
                Class<?> detectorClass = null;
                if (!(FindBugs.isNoAnalysis() || Detector.class.isAssignableFrom(detectorClass = this.classLoader.loadClass(className)) || Detector2.class.isAssignableFrom(detectorClass))) {
                    throw new PluginException("Class " + className + " does not implement Detector or Detector2");
                }
                DetectorFactory factory = new DetectorFactory(this.plugin, className, detectorClass, !"true".equals(disabled), speed, reports, requireJRE);
                if (Boolean.valueOf(hidden).booleanValue()) {
                    factory.setHidden(true);
                }
                factory.setPositionSpecifiedInPluginDescriptor(detectorCount++);
                this.plugin.addDetectorFactory(factory);
                Node node = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Detector[@class='" + className + "']/Details", "Missing Detector description for detector " + className);
                Element details2 = (Element)node;
                String detailHTML = details2.getText();
                StringBuilder buf = new StringBuilder();
                buf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
                buf.append("<HTML><HEAD><TITLE>Detector Description</TITLE></HEAD><BODY>\n");
                buf.append(detailHTML);
                buf.append("</BODY></HTML>\n");
                factory.setDetailHTML(buf.toString());
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Could not instantiate detector class: " + e, e);
        }
        Node orderingConstraintsNode = pluginDescriptor.selectSingleNode("/FindbugsPlugin/OrderingConstraints");
        if (orderingConstraintsNode != null) {
            List<Element> elements = XMLUtil.selectNodes(orderingConstraintsNode, "./SplitPass|./WithinPass");
            for (Element element : elements) {
                DetectorFactorySelector earlierSelector = this.getConstraintSelector(element, this.plugin, "Earlier");
                DetectorFactorySelector laterSelector = this.getConstraintSelector(element, this.plugin, "Later");
                DetectorOrderingConstraint constraint = new DetectorOrderingConstraint(earlierSelector, laterSelector);
                constraint.setSingleSource(earlierSelector instanceof SingleDetectorFactorySelector);
                if ("SplitPass".equals(element.getName())) {
                    this.plugin.addInterPassOrderingConstraint(constraint);
                    continue;
                }
                this.plugin.addIntraPassOrderingConstraint(constraint);
            }
        }
        List<Node> categoryNodeListGlobal = XMLUtil.selectNodes((Node)pluginDescriptor, "/FindbugsPlugin/BugCategory");
        for (Node node : categoryNodeListGlobal) {
            String key = node.valueOf("@category");
            if ("".equals(key)) {
                throw new PluginException("BugCategory element with missing category attribute");
            }
            BugCategory bc = this.plugin.addOrCreateBugCategory(key);
            boolean hidden = Boolean.valueOf(node.valueOf("@hidden"));
            if (!hidden) continue;
            bc.setHidden(hidden);
        }
        for (Document document : messageCollectionList) {
            List<Node> categoryNodeList = XMLUtil.selectNodes((Node)document, "/MessageCollection/BugCategory");
            LOG.debug("found {} categories in {}", (Object)categoryNodeList.size(), (Object)this.plugin.getPluginId());
            for (Node categoryNode : categoryNodeList) {
                String key = categoryNode.valueOf("@category");
                if ("".equals(key)) {
                    throw new PluginException("BugCategory element with missing category attribute");
                }
                BugCategory bc = this.plugin.addOrCreateBugCategory(key);
                String shortDesc = PluginLoader.getChildText(categoryNode, "Description");
                bc.setShortDescription(shortDesc);
                try {
                    String abbrev = PluginLoader.getChildText(categoryNode, "Abbreviation");
                    if (bc.getAbbrev() == null) {
                        bc.setAbbrev(abbrev);
                        LOG.debug("category {} abbrev -> {}", (Object)key, (Object)abbrev);
                    } else {
                        LOG.debug("rejected abbrev '{}' for category {}: {}", new Object[]{abbrev, key, bc.getAbbrev()});
                    }
                }
                catch (PluginException pe) {
                    System.out.println("missing Abbreviation for category " + key + "/" + shortDesc);
                }
                try {
                    String details3 = PluginLoader.getChildText(categoryNode, "Details");
                    if (bc.getDetailText() == null) {
                        bc.setDetailText(details3);
                        LOG.debug("category {} details -> {}", (Object)key, (Object)details3);
                        continue;
                    }
                    LOG.debug("rejected details [{}] for category {}: [{}]", new Object[]{details3, key, bc.getDetailText()});
                }
                catch (PluginException details3) {}
            }
        }
        List<Object> bugPatternNodeList = XMLUtil.selectNodes((Node)pluginDescriptor, "/FindbugsPlugin/BugPattern");
        for (Object bugPatternNode : bugPatternNodeList) {
            String type = bugPatternNode.valueOf("@type");
            String abbrev = bugPatternNode.valueOf("@abbrev");
            String category = bugPatternNode.valueOf("@category");
            boolean experimental = Boolean.parseBoolean(bugPatternNode.valueOf("@experimental"));
            String query = "/MessageCollection/BugPattern[@type='" + type + "']";
            Node messageNode = PluginLoader.findMessageNode(messageCollectionList, query, "messages.xml missing BugPattern element for type " + type);
            Node bugsUrlNode = messageNode.getDocument().selectSingleNode("/MessageCollection/Plugin/" + (experimental ? "AllBugsUrl" : "BugsUrl"));
            String bugsUrl = bugsUrlNode == null ? null : bugsUrlNode.getText();
            String shortDesc = PluginLoader.getChildText(messageNode, "ShortDescription");
            String longDesc = PluginLoader.getChildText(messageNode, "LongDescription");
            String detailText = PluginLoader.getChildText(messageNode, "Details");
            int cweid = 0;
            try {
                String cweString = bugPatternNode.valueOf("@cweid");
                if (cweString.length() > 0) {
                    cweid = Integer.parseInt(cweString);
                }
            }
            catch (RuntimeException cweString) {
                // empty catch block
            }
            BugPattern bugPattern = new BugPattern(type, abbrev, category, experimental, shortDesc, longDesc, detailText, bugsUrl, cweid);
            try {
                boolean deprecated;
                String deprecatedStr = bugPatternNode.valueOf("@deprecated");
                boolean bl = deprecated = deprecatedStr.length() > 0 && Boolean.valueOf(deprecatedStr) != false;
                if (deprecated) {
                    bugPattern.setDeprecated(deprecated);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.plugin.addBugPattern(bugPattern);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Document messageCollection : messageCollectionList) {
            List<Node> bugCodeNodeList = XMLUtil.selectNodes((Node)messageCollection, "/MessageCollection/BugCode");
            for (Node bugCodeNode : bugCodeNodeList) {
                String abbrev = bugCodeNode.valueOf("@abbrev");
                if ("".equals(abbrev)) {
                    throw new PluginException("BugCode element with missing abbrev attribute");
                }
                if (hashSet.contains(abbrev)) continue;
                String description = bugCodeNode.getText();
                String query = "/FindbugsPlugin/BugCode[@abbrev='" + abbrev + "']";
                Node fbNode = pluginDescriptor.selectSingleNode(query);
                int cweid = 0;
                if (fbNode != null) {
                    try {
                        cweid = Integer.parseInt(fbNode.valueOf("@cweid"));
                    }
                    catch (RuntimeException longDesc) {
                        // empty catch block
                    }
                }
                BugCode bugCode = new BugCode(abbrev, description, cweid);
                this.plugin.addBugCode(bugCode);
                hashSet.add(abbrev);
            }
        }
        Node node = pluginDescriptor.selectSingleNode("/FindbugsPlugin/EngineRegistrar");
        if (node != null) {
            String engineClassName = node.valueOf("@class");
            if (engineClassName == null) {
                throw new PluginException("EngineRegistrar element with missing class attribute");
            }
            try {
                Class<?> engineRegistrarClass = this.classLoader.loadClass(engineClassName);
                if (!IAnalysisEngineRegistrar.class.isAssignableFrom(engineRegistrarClass)) {
                    throw new PluginException(engineRegistrarClass + " does not implement IAnalysisEngineRegistrar");
                }
                this.plugin.setEngineRegistrarClass(engineRegistrarClass.asSubclass(IAnalysisEngineRegistrar.class));
            }
            catch (ClassNotFoundException e) {
                throw new PluginException("Could not instantiate analysis engine registrar class: " + e, e);
            }
        }
        try {
            URL bugRankURL = this.getResource("bugrank.txt");
            if (bugRankURL == null) {
                LOG.debug("No {} for plugin {}", (Object)"bugrank.txt", (Object)this.plugin.getPluginId());
            }
            BugRanker ranker = new BugRanker(bugRankURL);
            this.plugin.setBugRanker(ranker);
        }
        catch (IOException e) {
            throw new PluginException("Couldn't parse \"bugrank.txt\"", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Plugin constructMinimalPlugin(Document pluginDescriptor, List<Document> messageCollectionList) throws DuplicatePluginIdError {
        String updateUrl;
        String website;
        String pluginId = pluginDescriptor.valueOf(XPATH_PLUGIN_PLUGINID);
        if ("".equals(pluginId)) {
            Class<PluginLoader> clazz = PluginLoader.class;
            // MONITORENTER : edu.umd.cs.findbugs.PluginLoader.class
            pluginId = "plugin" + nextUnknownId++;
            // MONITOREXIT : clazz
        }
        this.cannotDisable = Boolean.parseBoolean(pluginDescriptor.valueOf("/FindbugsPlugin/@cannotDisable"));
        String de = pluginDescriptor.valueOf("/FindbugsPlugin/@defaultenabled");
        if (de != null && "false".equals(de.toLowerCase().trim())) {
            this.optionalPlugin = true;
        }
        if (this.optionalPlugin) {
            this.cannotDisable = false;
        }
        if (!loadedPluginIds.add(pluginId)) {
            Plugin existingPlugin = Plugin.getByPluginId(pluginId);
            URL u = existingPlugin == null ? null : existingPlugin.getPluginLoader().getURL();
            if (!this.cannotDisable) throw new DuplicatePluginIdException(pluginId, this.loadedFrom, u);
            if (!this.initialPlugin) throw new DuplicatePluginIdException(pluginId, this.loadedFrom, u);
            throw new DuplicatePluginIdError(pluginId, this.loadedFrom, u);
        }
        this.parentId = pluginDescriptor.valueOf("/FindbugsPlugin/@parentid");
        String version = pluginDescriptor.valueOf("/FindbugsPlugin/@version");
        String releaseDate = pluginDescriptor.valueOf("/FindbugsPlugin/@releaseDate");
        Date parsedDate = PluginLoader.parseDate(releaseDate);
        Plugin constructedPlugin = new Plugin(pluginId, version, parsedDate, this, !this.optionalPlugin, this.cannotDisable);
        String provider = pluginDescriptor.valueOf(XPATH_PLUGIN_PROVIDER).trim();
        if (!"".equals(provider)) {
            constructedPlugin.setProvider(provider);
        }
        if (!"".equals(website = pluginDescriptor.valueOf(XPATH_PLUGIN_WEBSITE).trim())) {
            try {
                constructedPlugin.setWebsite(website);
            }
            catch (URISyntaxException e1) {
                AnalysisContext.logError("Plugin " + constructedPlugin.getPluginId() + " has invalid website: " + website, e1);
            }
        }
        if (!"".equals(updateUrl = pluginDescriptor.valueOf("/FindbugsPlugin/@update-url").trim())) {
            try {
                constructedPlugin.setUpdateUrl(updateUrl);
            }
            catch (URISyntaxException e1) {
                AnalysisContext.logError("Plugin " + constructedPlugin.getPluginId() + " has invalid update check URL: " + website, e1);
            }
        }
        Node pluginShortDesc = null;
        try {
            pluginShortDesc = PluginLoader.findMessageNode(messageCollectionList, XPATH_PLUGIN_SHORT_DESCRIPTION, "no plugin description");
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
        if (pluginShortDesc != null) {
            constructedPlugin.setShortDescription(pluginShortDesc.getText().trim());
        }
        Node detailedDescription = null;
        try {
            detailedDescription = PluginLoader.findMessageNode(messageCollectionList, "/MessageCollection/Plugin/Details", "no plugin description");
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
        if (detailedDescription != null) {
            constructedPlugin.setDetailedDescription(detailedDescription.getText().trim());
        }
        List<Node> globalOptionNodes = XMLUtil.selectNodes((Node)pluginDescriptor, "/FindbugsPlugin/GlobalOptions/Property");
        Iterator<Node> iterator = globalOptionNodes.iterator();
        while (iterator.hasNext()) {
            Node optionNode = iterator.next();
            String key = optionNode.valueOf("@key");
            String value = optionNode.getText().trim();
            constructedPlugin.setMyGlobalOption(key, value);
        }
        return constructedPlugin;
    }

    public Document getPluginDescriptor() throws PluginException, PluginDoesntContainMetadataException {
        Document pluginDescriptor;
        String name = "findbugs.xml";
        URL findbugsXML_URL = this.getResource(name);
        if (findbugsXML_URL == null) {
            throw new PluginException("Couldn't find \"" + name + "\" in plugin " + this);
        }
        LOG.debug("PluginLoader found {} at: {}", (Object)name, (Object)findbugsXML_URL);
        if (!(this.jarName == null || findbugsXML_URL.toString().contains(this.jarName) || this.corePlugin && findbugsXML_URL.toString().endsWith("etc/findbugs.xml"))) {
            String classloaderName = this.classLoader.getClass().getName();
            if (this.classLoader instanceof URLClassLoader) {
                classloaderName = classloaderName + Arrays.asList(((URLClassLoader)this.classLoader).getURLs());
            }
            throw new PluginDoesntContainMetadataException((this.corePlugin ? "Core plugin" : "Plugin ") + this.jarName + " doesn't contain findbugs.xml; got " + findbugsXML_URL + " from " + classloaderName);
        }
        SAXReader reader = new SAXReader();
        try (InputStream input = IO.openNonCachedStream(findbugsXML_URL);
             BufferedReader r = UTF8.bufferedReader(input);){
            pluginDescriptor = reader.read((Reader)r);
        }
        catch (DocumentException e) {
            throw new PluginException("Couldn't parse \"" + findbugsXML_URL + "\" using " + reader.getClass().getName(), e);
        }
        catch (IOException e) {
            throw new PluginException("Couldn't open \"" + findbugsXML_URL + "\"", e);
        }
        return pluginDescriptor;
    }

    private static List<String> getPotentialMessageFiles() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        ArrayList<String> potential = new ArrayList<String>(3);
        if (country != null) {
            potential.add("messages_" + language + "_" + country + ".xml");
        }
        potential.add("messages_" + language + ".xml");
        potential.add("messages.xml");
        return potential;
    }

    private List<Document> getMessageDocuments() throws PluginException {
        ArrayList<Document> messageCollectionList = new ArrayList<Document>();
        PluginException caught = null;
        for (String m : PluginLoader.getPotentialMessageFiles()) {
            try {
                this.addCollection(messageCollectionList, m);
            }
            catch (PluginException e) {
                caught = e;
                AnalysisContext.logError("Error loading localized message file:" + m, e);
            }
        }
        if (messageCollectionList.isEmpty()) {
            if (caught != null) {
                throw caught;
            }
            throw new PluginException("No message.xml files found");
        }
        return messageCollectionList;
    }

    private <T> void loadComponentPlugin(Plugin plugin, Class<T> componentKind, @DottedClassName String componentClassname, String filterId, boolean disabled, String description, String details, PropertyBundle properties) throws PluginException {
        Class<T> componentClass = null;
        if (!FindBugs.isNoAnalysis() || componentKind == BugReporterDecorator.class) {
            componentClass = PluginLoader.getClass(this.classLoader, componentClassname, componentKind);
        }
        ComponentPlugin<T> componentPlugin = new ComponentPlugin<T>(plugin, filterId, this.classLoader, componentClass, properties, !disabled, description, details);
        plugin.addComponentPlugin(componentKind, componentPlugin);
    }

    private static Date parseDate(String releaseDate) {
        if (releaseDate == null || releaseDate.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat releaseDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm aa z", Locale.ENGLISH);
            Date result = releaseDateFormat.parse(releaseDate);
            return result;
        }
        catch (ParseException e) {
            AnalysisContext.logError("unable to parse date " + releaseDate, e);
            return null;
        }
    }

    private DetectorFactorySelector getConstraintSelector(Element constraintElement, Plugin plugin, String singleDetectorElementName) throws PluginException {
        boolean spanPlugins;
        Node node = constraintElement.selectSingleNode("./" + singleDetectorElementName);
        if (node != null) {
            String detectorClass = node.valueOf("@class");
            return new SingleDetectorFactorySelector(plugin, detectorClass);
        }
        node = constraintElement.selectSingleNode("./" + singleDetectorElementName + "Category");
        if (node != null) {
            spanPlugins = Boolean.valueOf(node.valueOf("@spanplugins"));
            String categoryName = node.valueOf("@name");
            if (!"".equals(categoryName)) {
                if ("reporting".equals(categoryName)) {
                    return new ReportingDetectorFactorySelector(spanPlugins ? null : plugin);
                }
                if ("training".equals(categoryName)) {
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, TrainingDetector.class);
                }
                if ("interprocedural".equals(categoryName)) {
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, InterproceduralFirstPassDetector.class);
                }
                throw new PluginException("Invalid category name " + categoryName + " in constraint selector node");
            }
        }
        if ((node = constraintElement.selectSingleNode("./" + singleDetectorElementName + "Subtypes")) != null) {
            spanPlugins = Boolean.valueOf(node.valueOf("@spanplugins"));
            String superName = node.valueOf("@super");
            if (!"".equals(superName)) {
                try {
                    Class<?> superClass = Class.forName(superName, true, this.classLoader);
                    return new ByInterfaceDetectorFactorySelector(spanPlugins ? null : plugin, superClass);
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException("Unknown class " + superName + " in constraint selector node");
                }
            }
        }
        throw new PluginException("Invalid constraint selector node");
    }

    private void addCollection(List<Document> messageCollectionList, String filename) throws PluginException {
        URL messageURL = this.getResource(filename);
        if (messageURL != null) {
            SAXReader reader = new SAXReader();
            try (InputStream input = IO.openNonCachedStream(messageURL);
                 BufferedReader stream = UTF8.bufferedReader(input);){
                Document messageCollection = reader.read((Reader)stream);
                messageCollectionList.add(messageCollection);
            }
            catch (IOException | DocumentException e) {
                throw new PluginException("Couldn't parse \"" + messageURL + "\"", e);
            }
        }
    }

    private static Node findMessageNode(List<Document> messageCollectionList, String xpath, String missingMsg) throws PluginException {
        for (Document document : messageCollectionList) {
            Node node = document.selectSingleNode(xpath);
            if (node == null) continue;
            return node;
        }
        throw new PluginException(missingMsg);
    }

    private static String findMessageText(List<Document> messageCollectionList, String xpath, String missingMsg) {
        for (Document document : messageCollectionList) {
            Node node = document.selectSingleNode(xpath);
            if (node == null) continue;
            return node.getText().trim();
        }
        return missingMsg;
    }

    private static String getChildText(Node node, String childName) throws PluginException {
        Node child = node.selectSingleNode(childName);
        if (child == null) {
            throw new PluginException("Could not find child \"" + childName + "\" for node");
        }
        return child.getText();
    }

    public static PluginLoader getPluginLoader(URL url, ClassLoader parent, boolean isInitial, boolean optional) throws PluginException {
        URI uri = PluginLoader.toUri(url);
        Plugin plugin = Plugin.getPlugin(uri);
        if (plugin != null) {
            PluginLoader loader = plugin.getPluginLoader();
            assert (loader.getClassLoader().getParent().equals(parent));
            return loader;
        }
        return new PluginLoader(url, uri, parent, isInitial, optional);
    }

    @Nonnull
    public static synchronized PluginLoader getCorePluginLoader() {
        Plugin plugin = Plugin.getPlugin(null);
        if (plugin != null) {
            return plugin.getPluginLoader();
        }
        throw new IllegalStateException("Core plugin not loaded yet!");
    }

    public boolean isCorePlugin() {
        return this.corePlugin;
    }

    static void installStandardPlugins() {
        String homeDir = DetectorFactoryCollection.getFindBugsHome();
        if (homeDir == null) {
            return;
        }
        File home = new File(homeDir);
        PluginLoader.loadPlugins(home);
    }

    private static void loadPlugins(File home) {
        if (home.canRead() && home.isDirectory()) {
            PluginLoader.loadPluginsInDir(new File(home, "plugin"), false);
            PluginLoader.loadPluginsInDir(new File(home, "optionalPlugin"), true);
        }
    }

    static void installUserInstalledPlugins() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            return;
        }
        File homeFindBugs = new File(new File(homeDir), ".findbugs");
        PluginLoader.loadPlugins(homeFindBugs);
    }

    private static void loadPluginsInDir(File pluginDir, boolean optional) {
        File[] contentList = pluginDir.listFiles();
        if (contentList == null) {
            return;
        }
        for (File file : contentList) {
            if (!file.getName().endsWith(".jar")) continue;
            try {
                URL url = file.toURI().toURL();
                if (!IO.verifyURL(url)) continue;
                PluginLoader.loadInitialPlugin(url, true, optional);
                if (!FindBugs.DEBUG) continue;
                System.out.println("Found plugin: " + file.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    static synchronized void loadInitialPlugins() {
        lazyInitialization = true;
        PluginLoader.loadCorePlugin();
        if (JavaWebStart.isRunningViaJavaWebstart()) {
            PluginLoader.installWebStartPlugins();
        } else {
            PluginLoader.installStandardPlugins();
            PluginLoader.installUserInstalledPlugins();
        }
        Set<Map.Entry<Object, Object>> entrySet = SystemProperties.getAllProperties().entrySet();
        for (Map.Entry<Object, Object> e : entrySet) {
            if (!(e.getKey() instanceof String) || !(e.getValue() instanceof String) || !((String)e.getKey()).startsWith("findbugs.plugin.")) continue;
            try {
                String value = (String)e.getValue();
                if (value.startsWith("file:") && !value.endsWith(".jar") && !value.endsWith("/")) {
                    value = value + "/";
                }
                URL url = JavaWebStart.resolveRelativeToJnlpCodebase(value);
                System.out.println("Loading " + e.getKey() + " from " + url);
                PluginLoader.loadInitialPlugin(url, true, false);
            }
            catch (MalformedURLException e1) {
                AnalysisContext.logError(String.format("Bad URL for plugin: %s=%s", e.getKey(), e.getValue()), e1);
            }
        }
        if (Plugin.getAllPlugins().size() > 1 && JavaWebStart.isRunningViaJavaWebstart()) {
            try {
                System.setSecurityManager(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        PluginLoader.finishLazyInitialization();
    }

    private static void loadCorePlugin() {
        try {
            Plugin plugin = Plugin.getPlugin(null);
            if (plugin != null) {
                throw new IllegalStateException("Already loaded");
            }
            PluginLoader pluginLoader = new PluginLoader();
            plugin = pluginLoader.getPlugin();
            Plugin.putPlugin(null, plugin);
        }
        catch (PluginException e1) {
            throw new IllegalStateException("Unable to load core plugin", e1);
        }
    }

    private static void loadInitialPlugin(URL u, boolean initial, boolean optional) {
        try {
            PluginLoader.getPluginLoader(u, PluginLoader.class.getClassLoader(), initial, optional);
        }
        catch (DuplicatePluginIdException duplicatePluginIdException) {
        }
        catch (PluginException e) {
            AnalysisContext.logError("Unable to load plugin from " + u, e);
            LOG.debug("Unable to load plugin from {}", (Object)u, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void installWebStartPlugins() {
        URL pluginListProperties = PluginLoader.getCoreResource("pluginlist.properties");
        BufferedReader in = null;
        if (pluginListProperties != null) {
            try {
                String plugin;
                DetectorFactoryCollection.jawsDebugMessage(pluginListProperties.toString());
                URL base = PluginLoader.getUrlBase(pluginListProperties);
                in = UTF8.bufferedReader(pluginListProperties.openStream());
                while ((plugin = in.readLine()) != null) {
                    URL url = new URL(base, plugin);
                    try {
                        URLConnection connection = url.openConnection();
                        String contentType = connection.getContentType();
                        DetectorFactoryCollection.jawsDebugMessage("contentType : " + contentType);
                        if (connection instanceof HttpURLConnection) {
                            ((HttpURLConnection)connection).disconnect();
                        }
                        PluginLoader.loadInitialPlugin(url, true, false);
                    }
                    catch (IOException e) {
                        DetectorFactoryCollection.jawsDebugMessage("error loading " + url + " : " + e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                try {
                    DetectorFactoryCollection.jawsDebugMessage("error : " + e.getMessage());
                }
                catch (Throwable throwable) {
                    Util.closeSilently(in);
                    throw throwable;
                }
                Util.closeSilently(in);
            }
            Util.closeSilently(in);
        }
    }

    private static URL getUrlBase(URL pluginListProperties) throws MalformedURLException {
        String urlname = pluginListProperties.toString();
        URL base = pluginListProperties;
        int pos = urlname.indexOf("!/");
        if (pos >= 0 && urlname.startsWith("jar:")) {
            urlname = urlname.substring(4, pos);
            base = new URL(urlname);
        }
        return base;
    }

    public String toString() {
        if (this.plugin == null) {
            return String.format("PluginLoader(%s)", this.loadedFrom);
        }
        return String.format("PluginLoader(%s, %s)", this.plugin.getPluginId(), this.loadedFrom);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Summary validate(File file) throws IllegalArgumentException {
        String path = file.getPath();
        if (!file.getName().endsWith(".jar")) {
            String message = "File " + path + " is not a .jar file";
            throw new IllegalArgumentException(message);
        }
        if (!file.isFile() || !file.canRead()) {
            String message = "File " + path + " is not a file or is not readable";
            throw new IllegalArgumentException(message);
        }
        if (file.length() == 0L) {
            String message = "File " + path + " is empty";
            throw new IllegalArgumentException(message);
        }
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry findbugsXML = zip.getEntry("findbugs.xml");
            if (findbugsXML == null) {
                throw new IllegalArgumentException("plugin doesn't contain a findbugs.xml file");
            }
            ZipEntry messagesXML = zip.getEntry("messages.xml");
            if (messagesXML == null) {
                throw new IllegalArgumentException("plugin doesn't contain a messages.xml file");
            }
            Document pluginDocument = PluginLoader.parseDocument(zip.getInputStream(findbugsXML));
            String pluginId = pluginDocument.valueOf(XPATH_PLUGIN_PLUGINID).trim();
            String provider = pluginDocument.valueOf(XPATH_PLUGIN_PROVIDER).trim();
            String website = pluginDocument.valueOf(XPATH_PLUGIN_WEBSITE).trim();
            ArrayList<Document> msgDocuments = new ArrayList<Document>(3);
            for (String msgFile : PluginLoader.getPotentialMessageFiles()) {
                ZipEntry msgEntry = zip.getEntry(msgFile);
                if (msgEntry == null) continue;
                Document msgDocument = PluginLoader.parseDocument(zip.getInputStream(msgEntry));
                msgDocuments.add(msgDocument);
            }
            String shortDesc = PluginLoader.findMessageText(msgDocuments, XPATH_PLUGIN_SHORT_DESCRIPTION, "");
            Summary summary = new Summary(pluginId, shortDesc, provider, website);
            return summary;
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseDocument(@WillClose InputStream in) throws DocumentException {
        BufferedReader r = UTF8.bufferedReader(in);
        try {
            Document d;
            SAXReader reader = new SAXReader();
            Document document = d = reader.read((Reader)r);
            return document;
        }
        finally {
            Util.closeSilently(r);
        }
    }

    static {
        loadedPluginIds = new HashSet();
        LOG.debug("Debugging plugin loading. SpotBugs version {}", (Object)Version.VERSION_STRING);
        PluginLoader.loadInitialPlugins();
    }

    public static class Summary {
        public final String id;
        public final String description;
        public final String provider;
        public final String webbsite;

        public Summary(String id, String description, String provider, String website) {
            this.id = id;
            this.description = description;
            this.provider = provider;
            this.webbsite = website;
        }
    }
}

