/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.JavaClass;

public class FindPuzzlers
extends OpcodeStackDetector {
    static FieldDescriptor SYSTEM_OUT = new FieldDescriptor("java/lang/System", "out", "Ljava/io/PrintStream;", true);
    static FieldDescriptor SYSTEM_ERR = new FieldDescriptor("java/lang/System", "err", "Ljava/io/PrintStream;", true);
    final BugReporter bugReporter;
    final BugAccumulator bugAccumulator;
    private final boolean testingEnabled;
    int becameTop;
    int imul_constant;
    int imul_distance;
    boolean imul_operand_is_parameter;
    int prevOpcodeIncrementedRegister;
    int valueOfConstantArgumentToShift;
    int best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG;
    boolean constantArgumentToShift;
    boolean shiftOfNonnegativeValue;
    int ternaryConversionState = 0;
    int badlyComputingOddState;
    int prevOpCode;
    XMethod previousMethodInvocation;
    boolean isTigerOrHigher;
    static ClassDescriptor ITERATOR = DescriptorFactory.createClassDescriptor(Iterator.class);
    static ClassDescriptor MAP_ENTRY = DescriptorFactory.createClassDescriptor(Map.Entry.class);
    BugInstance pendingUnreachableBranch;

    public FindPuzzlers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.testingEnabled = SystemProperties.getBoolean("report_TESTING_pattern_in_standard_detectors");
    }

    @Override
    public void visit(Code obj) {
        this.prevOpcodeIncrementedRegister = -1;
        this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = 4;
        this.prevOpCode = 0;
        this.previousMethodInvocation = null;
        this.badlyComputingOddState = 0;
        this.resetIMulCastLong();
        this.imul_distance = 10000;
        this.ternaryConversionState = 0;
        this.becameTop = -1;
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
        this.pendingUnreachableBranch = null;
    }

    @Override
    public void visit(JavaClass obj) {
        this.isTigerOrHigher = obj.getMajor() >= 49;
        try {
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            ClassDescriptor me = this.getClassDescriptor();
            if (subtypes2.isSubtype(me, MAP_ENTRY) && subtypes2.isSubtype(me, ITERATOR)) {
                this.bugReporter.reportBug(new BugInstance(this, "PZ_DONT_REUSE_ENTRY_OBJECTS_IN_ITERATORS", 2).addClass(this).addString("shouldn't reuse Iterator as a Map.Entry"));
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
    }

    private void resetIMulCastLong() {
        this.imul_constant = 1;
        this.imul_operand_is_parameter = false;
    }

    private int adjustPriority(int factor, int priority) {
        if (factor <= 4) {
            return 5;
        }
        if (factor <= 10000) {
            return priority + 1;
        }
        if (factor <= 3600000) {
            return priority;
        }
        return priority - 1;
    }

    private int adjustMultiplier(Object constant, int mul) {
        if (!(constant instanceof Integer)) {
            return mul;
        }
        return Math.abs((Integer)constant) * mul;
    }

    @Override
    public boolean beforeOpcode(int seen) {
        super.beforeOpcode(seen);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void sawOpcode(int seen) {
        if (this.stack.isTop()) {
            this.pendingUnreachableBranch = null;
            if (this.becameTop == -1) {
                this.becameTop = this.getPC();
            }
            if (this.testingEnabled && seen == 167 && this.getBranchTarget() < this.becameTop) {
                this.pendingUnreachableBranch = new BugInstance(this, "TESTING", 2).addClassAndMethod(this).addString("Unreachable loop body").addSourceLineRange(this, this.becameTop, this.getPC());
            }
            return;
        }
        if (this.pendingUnreachableBranch != null) {
            this.bugReporter.reportBug(this.pendingUnreachableBranch);
            this.pendingUnreachableBranch = null;
        }
        this.becameTop = -1;
        if ((seen == 183 && "<init>".equals(this.getNameConstantOperand()) && "(Ljava/util/Collection;)V".equals(this.getSigConstantOperand()) && this.getClassConstantOperand().contains("Set") || (seen == 182 || seen == 185) && "addAll".equals(this.getNameConstantOperand()) && "(Ljava/util/Collection;)Z".equals(this.getSigConstantOperand())) && (returnValueOf = (top = this.stack.getStackItem(0)).getReturnValueOf()) != null && "entrySet".equals(returnValueOf.getName())) {
            name = returnValueOf.getClassName();
            priority = 3;
            if ("java.util.Map".equals(name)) {
                priority = 2;
            } else if (name.equals(EnumMap.class.getName()) || name.equals(IdentityHashMap.class.getName())) {
                priority = 1;
            }
            this.bugReporter.reportBug(new BugInstance(this, "DMI_ENTRY_SETS_MAY_REUSE_ENTRY_OBJECTS", priority).addClassAndMethod(this).addCalledMethod(returnValueOf).addCalledMethod(this).addValueSource(top, this).addSourceLine(this));
        }
        if (seen == 182 && "hashCode".equals(this.getNameConstantOperand()) && "()I".equals(this.getSigConstantOperand()) && this.stack.getStackDepth() > 0 && (item0 = this.stack.getStackItem(0)).getSignature().charAt(0) == '[') {
            this.bugReporter.reportBug(new BugInstance(this, "DMI_INVOKING_HASHCODE_ON_ARRAY", 2).addClassAndMethod(this).addValueSource(item0, this).addSourceLine(this));
        }
        if (seen != 177 && this.isReturn(seen) && this.isRegisterStore(this.getPrevOpcode(1))) {
            priority = 2;
            if (this.getMethodSig().endsWith(")Z")) {
                priority = 1;
            } else {
                if (this.getMethodSig().endsWith(")Ljava/lang/String;")) {
                    priority = 3;
                }
                if (this.getPC() == this.getCode().getCode().length - 1) {
                    ++priority;
                }
            }
            this.bugReporter.reportBug(new BugInstance(this, "DLS_DEAD_LOCAL_STORE_IN_RETURN", priority).addClassAndMethod(this).addSourceLine(this));
        }
        if (seen == 104) {
            if (this.imul_distance != 1) {
                this.resetIMulCastLong();
            }
            this.imul_distance = 0;
            if (this.stack.getStackDepth() > 1) {
                item0 = this.stack.getStackItem(0);
                item1 = this.stack.getStackItem(1);
                this.imul_constant = this.adjustMultiplier(item0.getConstant(), this.imul_constant);
                this.imul_constant = this.adjustMultiplier(item1.getConstant(), this.imul_constant);
                if (item0.isInitialParameter() || item1.isInitialParameter()) {
                    this.imul_operand_is_parameter = true;
                }
            }
        } else {
            ++this.imul_distance;
        }
        if (this.prevOpCode == 104 && seen == 133) {
            priority = this.adjustPriority(this.imul_constant, 2);
            if (priority >= 3 && this.imul_constant != 1000 && this.imul_constant != 60 && this.imul_operand_is_parameter) {
                priority = 2;
            }
            if (priority <= this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG) {
                this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = priority;
                this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_INTEGER_MULTIPLY_CAST_TO_LONG", priority).addClassAndMethod(this), this);
            }
        }
        if ("<clinit>".equals(this.getMethodName()) && (seen == 179 || seen == 178 || seen == 184) && !(clazz = this.getClassConstantOperand()).equals(this.getClassName())) {
            try {
                targetClass = Repository.lookupClass((String)clazz);
                if (Repository.instanceOf((JavaClass)targetClass, (JavaClass)this.getThisClass())) {
                    priority = 2;
                    if (seen == 178) {
                        --priority;
                    }
                    if (!targetClass.isPublic()) {
                        ++priority;
                    }
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION", priority).addClassAndMethod(this).addClass(this.getClassConstantOperand()), this);
                }
            }
            catch (ClassNotFoundException targetClass) {
                // empty catch block
            }
        }
        if ((seen >= 46 && seen <= 53 || seen >= 79 && seen <= 86) && (index = this.stack.getStackItem(0)).getSpecialKind() == 6) {
            where = index.getPC() >= 0 ? SourceLineAnnotation.fromVisitedInstruction(this, index.getPC()) : SourceLineAnnotation.fromVisitedInstruction(this);
            this.bugAccumulator.accumulateBug(new BugInstance(this, "IM_AVERAGE_COMPUTATION_COULD_OVERFLOW", 2).addClassAndMethod(this), where);
        }
        if (!(seen != 153 && seen != 154 || this.getPrevOpcode(1) != 104 || this.getPrevOpcode(2) != 17 && this.getPrevOpcode(2) != 16 || this.getPrevOpcode(3) != 112)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "IM_MULTIPLYING_RESULT_OF_IREM", 3).addClassAndMethod(this), this);
        }
        if (!((seen != 147 || this.getPrevOpcode(1) != 124 || this.shiftOfNonnegativeValue || this.constantArgumentToShift && this.valueOfConstantArgumentToShift % 16 == 0) && (seen != 145 || this.getPrevOpcode(1) != 124 || this.shiftOfNonnegativeValue || this.constantArgumentToShift && this.valueOfConstantArgumentToShift % 8 == 0))) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_QUESTIONABLE_UNSIGNED_RIGHT_SHIFT", 2).addClassAndMethod(this), this);
        }
        if (seen == 96 && (this.getNextOpcode() == 120 || this.getNextOpcode() == 121) && this.stack.getStackDepth() >= 3) {
            l = this.stack.getStackItem(2);
            v = this.stack.getStackItem(1);
            constantValue = v.getConstant();
            if (constantValue instanceof Integer && !Integer.valueOf(1).equals(l.getConstant())) {
                c = (Integer)constantValue;
                priority = 3;
                if (c < 32 || c < 64 && this.getNextOpcode() == 121) {
                    if (c == 8) {
                        --priority;
                    }
                    if (this.getPrevOpcode(1) == 126) {
                        --priority;
                    }
                    if (this.getMethodName().equals("hashCode") && this.getMethodSig().equals("()I") && (this.getCode().getCode()[this.getNextPC() + 1] & 255) == 172) {
                        priority = 1;
                    }
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "BSHIFT_WRONG_ADD_PRIORITY", priority).addClassAndMethod(this).addInt(c).describe("INT_SHIFT").addValueSource(this.stack.getStackItem(2), this).addValueSource(this.stack.getStackItem(0), this), this);
                }
            }
        }
        this.constantArgumentToShift = false;
        this.shiftOfNonnegativeValue = false;
        if (seen == 124 || seen == 122 || seen == 120) {
            if (this.stack.getStackDepth() <= 1) {
                this.constantArgumentToShift = true;
                this.valueOfConstantArgumentToShift = 8;
            } else {
                rightHandSide = this.stack.getStackItem(0).getConstant();
                leftHandSide = this.stack.getStackItem(1).getConstant();
                this.shiftOfNonnegativeValue = this.stack.getStackItem(1).isNonNegative();
                if (rightHandSide instanceof Integer) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = (Integer)rightHandSide;
                    if (this.valueOfConstantArgumentToShift < 0 || this.valueOfConstantArgumentToShift >= 32) {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "ICAST_BAD_SHIFT_AMOUNT", this.valueOfConstantArgumentToShift < 0 ? 3 : (this.valueOfConstantArgumentToShift == 32 && "hashCode".equals(this.getMethodName()) != false ? 2 : 1)).addClassAndMethod(this).addInt(this.valueOfConstantArgumentToShift).describe("INT_SHIFT").addValueSource(this.stack.getStackItem(1), this), this);
                    }
                }
                if (leftHandSide instanceof Integer && (Integer)leftHandSide > 0) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = 8;
                }
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && ("java/util/Date".equals(this.getClassConstantOperand()) || "java/sql/Date".equals(this.getClassConstantOperand())) && "setMonth".equals(this.getNameConstantOperand()) && "(I)V".equals(this.getSigConstantOperand()) && (o = (item = this.stack.getStackItem(0)).getConstant()) instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance(this, "DMI_BAD_MONTH", 1).addClassAndMethod(this).addInt(v).describe("INT_VALUE").addCalledMethod(this).addSourceLine(this));
        }
        if ((seen == 182 && this.stack.getStackDepth() > 1 && "java/util/Calendar".equals(this.getClassConstantOperand()) && "set".equals(this.getNameConstantOperand()) || seen == 183 && this.stack.getStackDepth() > 1 && "java/util/GregorianCalendar".equals(this.getClassConstantOperand()) && "<init>".equals(this.getNameConstantOperand())) && (sig = this.getSigConstantOperand()).startsWith("(III") && (o = (item = this.stack.getStackItem(pos = sig.length() - 5)).getConstant()) instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance(this, "DMI_BAD_MONTH", 2).addClassAndMethod(this).addInt(v).describe("INT_VALUE").addCalledMethod(this).addSourceLine(this));
        }
        if (this.isRegisterStore() && (seen == 54 || seen == 59 || seen == 60 || seen == 61 || seen == 62) && this.getRegisterOperand() == this.prevOpcodeIncrementedRegister) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "DLS_OVERWRITTEN_INCREMENT", 1).addClassAndMethod(this), this);
        }
        this.prevOpcodeIncrementedRegister = seen == 132 ? this.getRegisterOperand() : -1;
        switch (this.badlyComputingOddState) {
            case 0: {
                if (seen != 5) break;
                ++this.badlyComputingOddState;
                break;
            }
            case 1: {
                if (seen == 112) {
                    item = this.stack.getStackItem(1);
                    if (!item.isNonNegative() && item.getSpecialKind() != 11) {
                        ++this.badlyComputingOddState;
                        break;
                    }
                    this.badlyComputingOddState = 0;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 2: {
                if (seen == 4) {
                    ++this.badlyComputingOddState;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 3: {
                if (seen == 159 || seen == 160) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "IM_BAD_CHECK_FOR_ODD", 2).addClassAndMethod(this), this);
                }
                this.badlyComputingOddState = 0;
                break;
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && ("toString".equals(this.getNameConstantOperand()) != false && "()Ljava/lang/String;".equals(this.getSigConstantOperand()) != false || "append".equals(this.getNameConstantOperand()) != false && "(Ljava/lang/Object;)Ljava/lang/StringBuilder;".equals(this.getSigConstantOperand()) != false && "java/lang/StringBuilder".equals(this.getClassConstantOperand()) != false || "append".equals(this.getNameConstantOperand()) != false && "(Ljava/lang/Object;)Ljava/lang/StringBuffer;".equals(this.getSigConstantOperand()) != false && "java/lang/StringBuffer".equals(this.getClassConstantOperand()) != false || ("print".equals(this.getNameConstantOperand()) || "println".equals(this.getNameConstantOperand())) && "(Ljava/lang/Object;)V".equals(this.getSigConstantOperand())) && (signature = (item = this.stack.getStackItem(0)).getSignature()) != null && signature.startsWith("[")) {
            debuggingContext = "[Ljava/lang/StackTraceElement;".equals(signature);
            if (!debuggingContext) {
                for (CodeException e : this.getCode().getExceptionTable()) {
                    if (e.getHandlerPC() > this.getPC() || e.getHandlerPC() + 30 < this.getPC()) continue;
                    debuggingContext = true;
                }
                for (i = 1; !debuggingContext && i < this.stack.getStackDepth(); ++i) {
                    e = this.stack.getStackItem(i);
                    if (e.getSignature().indexOf("Logger") >= 0 || e.getSignature().indexOf("Exception") >= 0) {
                        debuggingContext = true;
                    }
                    if ((f = e.getXField()) == null || !FindPuzzlers.SYSTEM_ERR.equals(f.getFieldDescriptor()) && !FindPuzzlers.SYSTEM_OUT.equals(f.getFieldDescriptor())) continue;
                    debuggingContext = true;
                }
            }
            reg = item.getRegisterNumber();
            as = new ArrayList<BugAnnotation>();
            field = item.getXField();
            fieldAnnotation = null;
            if (field != null) {
                fieldAnnotation = FieldAnnotation.fromXField(field);
                fieldAnnotation.setDescription("FIELD_VALUE_OF");
            }
            if (reg != -1) {
                lva = LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), reg, this.getPC(), this.getPC() - 1);
                if (lva.isNamed()) {
                    as.add(lva);
                    if (fieldAnnotation != null) {
                        as.add(fieldAnnotation);
                    }
                } else {
                    if (fieldAnnotation != null) {
                        as.add(fieldAnnotation);
                    }
                    as.add(lva);
                }
            } else if (fieldAnnotation != null) {
                as.add(fieldAnnotation);
            } else {
                m = item.getReturnValueOf();
                if (m != null) {
                    methodAnnotation = MethodAnnotation.fromXMethod(m);
                    methodAnnotation.setDescription("METHOD_RETURN_VALUE_OF");
                    as.add(methodAnnotation);
                }
            }
            v0 = priority = debuggingContext != false ? 2 : 1;
            if (!as.isEmpty()) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_INVOKING_TOSTRING_ON_ARRAY", priority).addClassAndMethod(this).addAnnotations(as), this);
            } else {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_INVOKING_TOSTRING_ON_ANONYMOUS_ARRAY", priority).addClassAndMethod(this), this);
            }
        }
        if (this.isTigerOrHigher) {
            if (this.previousMethodInvocation != null && this.prevOpCode == 182 && seen == 184) {
                classNameForPreviousMethod = this.previousMethodInvocation.getClassName();
                classNameForThisMethod = this.getClassConstantOperand();
                if (classNameForPreviousMethod.startsWith("java.lang.") && classNameForPreviousMethod.equals(classNameForThisMethod.replace('/', '.')) && this.previousMethodInvocation.getName().endsWith("Value") && this.previousMethodInvocation.getSignature().length() == 3 && "valueOf".equals(this.getNameConstantOperand()) && this.getSigConstantOperand().charAt(1) == this.previousMethodInvocation.getSignature().charAt(2)) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "BX_UNBOXING_IMMEDIATELY_REBOXED", 2).addClassAndMethod(this).addCalledMethod(this), this);
                }
            }
            if (this.previousMethodInvocation != null && this.prevOpCode == 183 && seen == 182) {
                classNameForPreviousMethod = this.previousMethodInvocation.getClassName();
                classNameForThisMethod = this.getClassConstantOperand();
                if (classNameForPreviousMethod.startsWith("java.lang.") && classNameForPreviousMethod.equals(classNameForThisMethod.replace('/', '.')) && this.getNameConstantOperand().endsWith("Value") && this.getSigConstantOperand().length() == 3) {
                    if (this.getSigConstantOperand().charAt(2) == this.previousMethodInvocation.getSignature().charAt(1)) {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "BX_BOXING_IMMEDIATELY_UNBOXED", 2).addClassAndMethod(this), this);
                    } else {
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "BX_BOXING_IMMEDIATELY_UNBOXED_TO_PERFORM_COERCION", 2).addClassAndMethod(this), this);
                    }
                    this.ternaryConversionState = 1;
                } else {
                    this.ternaryConversionState = 0;
                }
            } else if (seen == 182) {
                this.ternaryConversionState = this.getClassConstantOperand().startsWith("java/lang") && this.getNameConstantOperand().endsWith("Value") && this.getSigConstantOperand().length() == 3 ? 1 : 0;
            } else if (this.ternaryConversionState == 1) {
                this.ternaryConversionState = 133 < seen && seen <= 147 ? 2 : 0;
            } else if (this.ternaryConversionState == 2) {
                this.ternaryConversionState = 0;
                if (seen == 167) {
                    this.bugReporter.reportBug(new BugInstance(this, "BX_UNBOXED_AND_COERCED_FOR_TERNARY_OPERATOR", 2).addClassAndMethod(this).addSourceLine(this));
                }
            } else {
                this.ternaryConversionState = 0;
            }
        }
        if (seen == 184 && (this.getNameConstantOperand().startsWith("assert") || this.getNameConstantOperand().startsWith("fail")) && "run".equals(this.getMethodName()) && this.implementsRunnable(this.getThisClass())) {
            size1 = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getMethod().getCode(), "java/lang/Throwable", this.getPC());
            size2 = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getMethod().getCode(), "java/lang/Error", this.getPC());
            size3 = Util.getSizeOfSurroundingTryBlock(this.getConstantPool(), this.getMethod().getCode(), "java/lang/AssertionFailureError", this.getPC());
            size = Math.min(Math.min(size1, size2), size3);
            if (size == 0x7FFFFFFF) {
                dottedClassName = this.getClassConstantOperand().replace('/', '.');
                if (!dottedClassName.startsWith("junit")) {
                    try {
                        targetClass = AnalysisContext.currentAnalysisContext().lookupClass(dottedClassName);
                        if (!targetClass.getSuperclassName().startsWith("junit")) {
                        }
                        ** break block100
                    }
                    catch (ClassNotFoundException e) {
                        AnalysisContext.reportMissingClass(e);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "IJU_ASSERT_METHOD_INVOKED_FROM_RUN_METHOD", this.extendsThread(this.getThisClass()) != false ? 2 : 3).addClassAndMethod(this), this);
                }
            }
        }
        this.previousMethodInvocation = seen == 183 && this.getClassConstantOperand().startsWith("java/lang/") != false && "<init>".equals(this.getNameConstantOperand()) != false && this.getSigConstantOperand().length() == 4 ? XFactory.createReferencedXMethod(this) : (seen == 184 && this.getClassConstantOperand().startsWith("java/lang/") != false && "valueOf".equals(this.getNameConstantOperand()) != false && this.getSigConstantOperand().length() == 4 ? XFactory.createReferencedXMethod(this) : (seen == 182 && this.getClassConstantOperand().startsWith("java/lang/") != false && this.getNameConstantOperand().endsWith("Value") != false && this.getSigConstantOperand().length() == 3 ? XFactory.createReferencedXMethod(this) : null));
        if (this.testingEnabled && seen == 126 || seen == 127) {
            rhs = this.stack.getStackItem(0);
            lhs = this.stack.getStackItem(1);
            constant = rhs.getConstant();
            value = lhs;
            if (constant == null) {
                constant = lhs.getConstant();
                value = rhs;
            }
            if (constant instanceof Number && (seen == 127 || value.getSpecialKind() == 22) && ((constantValue = ((Number)constant).longValue()) == 0xEFFFFFFFL || constantValue == -1152921504606846977L || seen == 126 && constantValue == -268435457L)) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "TESTING", seen == 127 ? 1 : 2).addClassAndMethod(this).addString("Possible failed attempt to mask lower 31 bits of an int").addValueSource(value, this), this);
            }
        }
        if (seen == 116 && (m = (top = this.stack.getStackItem(0)).getReturnValueOf()) != null && ("compareTo".equals(m.getName()) || "compare".equals(m.getName()))) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "RV_NEGATING_RESULT_OF_COMPARETO", 2).addClassAndMethod(this).addCalledMethod(m).addValueSource(top, this), this);
        }
        this.prevOpCode = seen;
    }

    boolean implementsRunnable(JavaClass obj) {
        return Subtypes2.instanceOf(obj, "java.lang.Runnable");
    }

    boolean extendsThread(JavaClass obj) {
        return Subtypes2.instanceOf(obj, "java.lang.Thread");
    }
}

