/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FieldWarningSuppressor;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.MethodWarningSuppressor;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.PackageWarningSuppressor;
import edu.umd.cs.findbugs.ParameterWarningSuppressor;
import edu.umd.cs.findbugs.SuppressionMatcher;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class NoteSuppressedWarnings
extends AnnotationVisitor
implements Detector,
NonReportingDetector {
    private final Set<String> packages = new HashSet<String>();
    private final SuppressionMatcher suppressionMatcher = AnalysisContext.currentAnalysisContext().getSuppressionMatcher();

    public NoteSuppressedWarnings(BugReporter bugReporter) {
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (!BCELUtil.preTiger(javaClass)) {
            String packageName;
            String name = javaClass.getClassName();
            int i = name.lastIndexOf(46);
            String string = packageName = i < 0 ? "" : name.substring(0, i);
            if (name.endsWith(".package-info")) {
                if (!this.packages.add(packageName)) {
                    return;
                }
            } else if (this.packages.add(packageName)) {
                try {
                    JavaClass packageInfoClass = Repository.lookupClass((String)(packageName + ".package-info"));
                    packageInfoClass.accept((Visitor)this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            javaClass.accept((Visitor)this);
        }
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (!this.isSuppressWarnings(annotationClass)) {
            return;
        }
        String[] suppressed = NoteSuppressedWarnings.getAnnotationParameterAsStringArray(map, "value");
        if (suppressed == null || suppressed.length == 0) {
            this.suppressWarning(null);
        } else {
            for (String s : suppressed) {
                this.suppressWarning(s);
            }
        }
    }

    public boolean isSuppressWarnings(String annotationClass) {
        return annotationClass.endsWith("SuppressWarnings") || annotationClass.endsWith("SuppressFBWarnings");
    }

    @Override
    public void visitParameterAnnotation(int p, String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        String[] suppressed;
        if (!this.isSuppressWarnings(annotationClass)) {
            return;
        }
        if (!this.getMethod().isStatic()) {
            ++p;
        }
        if ((suppressed = NoteSuppressedWarnings.getAnnotationParameterAsStringArray(map, "value")) == null || suppressed.length == 0) {
            this.suppressWarning(p, null);
        } else {
            for (String s : suppressed) {
                this.suppressWarning(p, s);
            }
        }
    }

    private void suppressWarning(int parameter, String pattern) {
        String className = this.getDottedClassName();
        ClassAnnotation clazz = new ClassAnnotation(className);
        this.suppressionMatcher.addSuppressor(new ParameterWarningSuppressor(pattern, clazz, MethodAnnotation.fromVisitedMethod(this), parameter));
    }

    private void suppressWarning(String pattern) {
        String className = this.getDottedClassName();
        ClassAnnotation clazz = new ClassAnnotation(className);
        if (className.endsWith(".package-info")) {
            this.suppressionMatcher.addPackageSuppressor(new PackageWarningSuppressor(pattern, this.getPackageName().replace('/', '.')));
        } else if (this.visitingMethod()) {
            this.suppressionMatcher.addSuppressor(new MethodWarningSuppressor(pattern, clazz, MethodAnnotation.fromVisitedMethod(this)));
        } else if (this.visitingField()) {
            this.suppressionMatcher.addSuppressor(new FieldWarningSuppressor(pattern, clazz, FieldAnnotation.fromVisitedField(this)));
        } else {
            this.suppressionMatcher.addSuppressor(new ClassWarningSuppressor(pattern, clazz));
        }
    }

    @Override
    public void report() {
    }
}

