/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceMatcher
implements Matcher {
    private static final Logger LOG = LoggerFactory.getLogger(SourceMatcher.class);
    private final NameMatch fileName;

    public String toString() {
        return "Source(file=\"" + this.fileName.getValue() + "\")";
    }

    public SourceMatcher(String fileName) {
        this.fileName = new NameMatch(fileName);
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        ClassAnnotation primaryClassAnnotation = bugInstance.getPrimaryClass();
        if (primaryClassAnnotation == null) {
            return false;
        }
        String bugFileName = primaryClassAnnotation.getSourceFileName();
        if (bugFileName == null || bugFileName.isEmpty()) {
            return false;
        }
        boolean result = this.fileName.match(bugFileName);
        LOG.debug("Matching {} with {}, result = {}", new Object[]{bugFileName, this.fileName, result});
        return result;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.fileName.getSpec());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Source", attributes);
    }
}

