/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public abstract class AbstractBlockOrder
implements BlockOrder {
    private final ArrayList<BasicBlock> blockList;
    private final Comparator<BasicBlock> comparator;

    public AbstractBlockOrder(CFG cfg, Comparator<BasicBlock> comparator) {
        this.comparator = comparator;
        int numBlocks = cfg.getNumBasicBlocks();
        this.blockList = new ArrayList(cfg.getNumBasicBlocks());
        for (BasicBlock bb : cfg.blocks()) {
            this.blockList.add(bb);
        }
        assert (this.blockList.size() == numBlocks);
        Collections.sort(this.blockList, comparator);
    }

    @Override
    public Iterator<BasicBlock> blockIterator() {
        return this.blockList.iterator();
    }

    @Override
    public int compare(BasicBlock b1, BasicBlock b2) {
        return this.comparator.compare(b1, b2);
    }
}

