/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bcel;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.ObjectType;

public abstract class BCELUtil {
    private static final int JDK15_MAJOR = 48;
    private static final int JDK15_MINOR = 0;

    public static MethodDescriptor getMethodDescriptor(JavaClass jclass, Method method) {
        return DescriptorFactory.instance().getMethodDescriptor(jclass.getClassName().replace('.', '/'), method.getName(), method.getSignature(), method.isStatic());
    }

    public static ClassDescriptor getClassDescriptor(JavaClass jclass) {
        return DescriptorFactory.instance().getClassDescriptor(ClassName.toSlashedClassName(jclass.getClassName()));
    }

    public static boolean preTiger(JavaClass jclass) {
        return jclass.getMajor() < 48 || jclass.getMajor() == 48 && jclass.getMinor() < 0;
    }

    public static ObjectType getObjectTypeInstance(@DottedClassName String className) {
        return ObjectType.getInstance((String)className);
    }

    @Deprecated
    public static boolean isSynthetic(FieldOrMethod m) {
        if (m.isSynthetic()) {
            return true;
        }
        for (Attribute a : m.getAttributes()) {
            if (!(a instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSynthetic(JavaClass j) {
        if (j.isSynthetic()) {
            return true;
        }
        for (Attribute a : j.getAttributes()) {
            if (!(a instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSynthetic(FieldGenOrMethodGen m) {
        if (m.isSynthetic()) {
            return true;
        }
        for (Attribute a : m.getAttributes()) {
            if (!(a instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }
}

