/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Collections;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class WrongMapIterator
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final Set<MethodDescriptor> methods = Collections.singleton(new MethodDescriptor("", "keySet", "()Ljava/util/Set;"));
    final LoadedVariable NONE;
    private final BugAccumulator bugAccumulator;
    private static final int NOT_FOUND = -2;
    private static final int IN_STACK = -1;
    private LoadedVariable loadedVariable;
    private LoadedVariable mapVariable;
    private int keySetRegister;
    private int iteratorRegister;
    private int keyRegister;
    private boolean mapAndKeyLoaded;

    public WrongMapIterator(BugReporter bugReporter) {
        this.loadedVariable = this.NONE = new LoadedVariable(LoadedVariableState.NOTHING, 0, null);
        this.mapVariable = this.NONE;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (WrongMapIterator.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), methods)) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(Method obj) {
        this.reset();
    }

    private void reset() {
        this.loadedVariable = this.NONE;
        this.mapVariable = this.NONE;
        this.mapAndKeyLoaded = false;
        this.keySetRegister = -2;
        this.iteratorRegister = -2;
        this.keyRegister = -2;
    }

    @Override
    public void visit(Code code) {
        super.visit(code);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private static boolean implementsMap(ClassDescriptor d) {
        while (d != null) {
            try {
                if ("java.util.EnumMap".equals(d.getDottedClassName())) {
                    return false;
                }
                if ("java.util.Map".equals(d.getDottedClassName())) {
                    return true;
                }
                XClass classNameAndInfo = Global.getAnalysisCache().getClassAnalysis(XClass.class, d);
                ClassDescriptor[] is = classNameAndInfo.getInterfaceDescriptorList();
                d = classNameAndInfo.getSuperclassDescriptor();
                for (ClassDescriptor i : is) {
                    if (!"java.util.Map".equals(i.getDottedClassName())) continue;
                    return true;
                }
            }
            catch (CheckedAnalysisException e) {
                d = null;
            }
        }
        return false;
    }

    private int handleStore(int storeRegister, int current) {
        if (storeRegister == current) {
            return -2;
        }
        if (current == -1) {
            return storeRegister;
        }
        return current;
    }

    private void handleStore(int register) {
        this.keySetRegister = this.handleStore(register, this.keySetRegister);
        this.iteratorRegister = this.handleStore(register, this.iteratorRegister);
        this.keyRegister = this.handleStore(register, this.keyRegister);
    }

    private void removedFromStack(boolean includeKey) {
        if (this.keySetRegister == -1) {
            this.keySetRegister = -2;
        }
        if (this.iteratorRegister == -1) {
            this.iteratorRegister = -2;
        }
        if (this.keyRegister == -1 && includeKey) {
            this.keyRegister = -2;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        boolean loadedPreserved = false;
        if (this.isRegisterStore() && !this.isRegisterLoad()) {
            this.handleStore(this.getRegisterOperand());
        } else {
            switch (seen) {
                case 182: 
                case 185: {
                    if (!this.loadedVariable.none() && "keySet".equals(this.getNameConstantOperand()) && "()Ljava/util/Set;".equals(this.getSigConstantOperand()) && WrongMapIterator.implementsMap(this.getClassDescriptorOperand())) {
                        try {
                            TypeDataflow.LocationAndFactPair lfp = this.getClassContext().getTypeDataflow(this.getMethod()).getLocationAndFactForInstruction(this.getPC());
                            if (lfp != null && ((Type)lfp.frame.getTopValue()).getSignature().equals("Ljava/util/EnumMap;")) {
                                break;
                            }
                        }
                        catch (CFGBuilderException | DataflowAnalysisException lfp) {
                            // empty catch block
                        }
                        this.mapVariable = this.loadedVariable;
                        this.removedFromStack(true);
                        this.keySetRegister = -1;
                        break;
                    }
                    if ((this.keySetRegister == -1 || this.loadedVariable.isRegister(this.keySetRegister)) && "iterator".equals(this.getNameConstantOperand()) && "()Ljava/util/Iterator;".equals(this.getSigConstantOperand())) {
                        this.removedFromStack(true);
                        this.iteratorRegister = -1;
                        break;
                    }
                    if ((this.iteratorRegister == -1 || this.loadedVariable.isRegister(this.iteratorRegister)) && "next".equals(this.getNameConstantOperand()) && "()Ljava/lang/Object;".equals(this.getSigConstantOperand())) {
                        this.removedFromStack(true);
                        this.keyRegister = -1;
                        break;
                    }
                    if (this.mapAndKeyLoaded && "get".equals(this.getNameConstantOperand()) && "(Ljava/lang/Object;)Ljava/lang/Object;".equals(this.getSigConstantOperand())) {
                        MethodAnnotation ma = MethodAnnotation.fromVisitedMethod(this);
                        this.bugAccumulator.accumulateBug(this.mapVariable.annotate(new BugInstance(this, "WMI_WRONG_MAP_ITERATOR", 2).addClass(this).addMethod(ma)), this);
                        this.reset();
                        break;
                    }
                    if ("intValue".equals(this.getNameConstantOperand()) && "java/lang/Integer".equals(this.getClassConstantOperand()) || "longValue".equals(this.getNameConstantOperand()) && "java/lang/Long".equals(this.getClassConstantOperand()) || "doubleValue".equals(this.getNameConstantOperand()) && "java/lang/Double".equals(this.getClassConstantOperand()) || "floatValue".equals(this.getNameConstantOperand()) && "java/lang/Float".equals(this.getClassConstantOperand())) {
                        this.removedFromStack(false);
                        break;
                    }
                    this.removedFromStack(true);
                    break;
                }
                case 184: {
                    if ("valueOf".equals(this.getNameConstantOperand()) && ("java/lang/Integer".equals(this.getClassConstantOperand()) || "java/lang/Long".equals(this.getClassConstantOperand()) || "java/lang/Double".equals(this.getClassConstantOperand()) || "java/lang/Float".equals(this.getClassConstantOperand()))) {
                        loadedPreserved = true;
                    }
                    this.removedFromStack(true);
                    break;
                }
                case 192: {
                    this.removedFromStack(false);
                    break;
                }
                default: {
                    this.removedFromStack(true);
                }
            }
        }
        if (!loadedPreserved) {
            boolean mapLoaded = !this.loadedVariable.none() && this.loadedVariable.same(this.mapVariable);
            this.loadedVariable = this.loadedVariable.seen(seen);
            this.mapAndKeyLoaded = mapLoaded && this.loadedVariable.isRegister(this.keyRegister);
        }
    }

    final class LoadedVariable {
        private final LoadedVariableState lvState;
        private final int num;
        private final FieldDescriptor fd;

        private LoadedVariable(LoadedVariableState state, int num, FieldDescriptor fd) {
            this.lvState = state;
            this.num = num;
            this.fd = fd;
        }

        public boolean none() {
            return this.lvState == LoadedVariableState.NOTHING;
        }

        public boolean isRegister(int register) {
            return this.lvState == LoadedVariableState.LOCAL && this.num == register;
        }

        public LoadedVariable seen(int opcode) {
            if (WrongMapIterator.this.isRegisterLoad() && !WrongMapIterator.this.isRegisterStore()) {
                return new LoadedVariable(LoadedVariableState.LOCAL, WrongMapIterator.this.getRegisterOperand(), null);
            }
            switch (opcode) {
                case 178: {
                    return new LoadedVariable(LoadedVariableState.FIELD, 0, WrongMapIterator.this.getFieldDescriptorOperand());
                }
                case 180: {
                    if (this.lvState == LoadedVariableState.LOCAL && this.num == 0) {
                        return new LoadedVariable(LoadedVariableState.FIELD, 0, WrongMapIterator.this.getFieldDescriptorOperand());
                    }
                    return WrongMapIterator.this.NONE;
                }
            }
            return WrongMapIterator.this.NONE;
        }

        public boolean same(LoadedVariable other) {
            return !(other.lvState != this.lvState || this.lvState == LoadedVariableState.LOCAL && this.num != other.num || this.lvState == LoadedVariableState.FIELD && !this.fd.equals(other.fd));
        }

        public BugInstance annotate(BugInstance bug) {
            if (this.lvState == LoadedVariableState.FIELD) {
                bug.addField(this.fd);
            }
            return bug;
        }
    }

    static enum LoadedVariableState {
        NOTHING,
        LOCAL,
        FIELD;

    }
}

