/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.MainFrame;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import javax.swing.tree.TreePath;

public class FilterActivity {
    private static final HashSet<FilterListener> listeners = new HashSet();

    public static boolean addFilterListener(FilterListener newListener) {
        return listeners.add(newListener);
    }

    public static void removeFilterListener(FilterListener toRemove) {
        listeners.remove(toRemove);
    }

    public static void notifyListeners(FilterListener.Action whatsGoingOnCode, @CheckForNull TreePath optionalPath) {
        ArrayList<FilterListener> currentListeners = new ArrayList<FilterListener>(listeners);
        switch (whatsGoingOnCode) {
            case FILTERING: 
            case UNFILTERING: {
                for (FilterListener i : currentListeners) {
                    i.clearCache();
                }
                break;
            }
        }
        MainFrame.getInstance().updateStatusBar();
    }

    public static class FilterActivityNotifier {
        public void notifyListeners(FilterListener.Action whatsGoingOnCode, TreePath optionalPath) {
            FilterActivity.notifyListeners(whatsGoingOnCode, optionalPath);
        }
    }
}

