/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.log;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.log.IProfiler;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Profiler
implements IProfiler,
XMLWriteable {
    static final boolean REPORT = SystemProperties.getBoolean("profiler.report");
    static final boolean MAX_CONTEXT = SystemProperties.getBoolean("findbugs.profiler.maxcontext");
    private final Stack<Clock> startTimes = new Stack();
    private final Stack<Object> context = new Stack();
    private final ConcurrentMap<Class<?>, Profile> profile = new ConcurrentHashMap();

    public Profiler() {
        if (REPORT) {
            System.err.println("Profiling activated");
        }
    }

    public void startContext(Object context) {
        this.context.push(context);
    }

    public void endContext(Object context) {
        Object o = this.context.pop();
        assert (o == context);
    }

    private Object getContext() {
        if (this.context.size() == 0) {
            return "";
        }
        try {
            return this.context.peek();
        }
        catch (EmptyStackException e) {
            return "";
        }
    }

    public void start(Class<?> c) {
        long currentNanoTime = System.nanoTime();
        Stack<Clock> stack = this.startTimes;
        if (!stack.isEmpty()) {
            stack.peek().accumulateTime(currentNanoTime);
        }
        stack.push(new Clock(c, currentNanoTime));
    }

    public void end(Class<?> c) {
        Profile counter2;
        long accumulatedTime;
        long currentNanoTime = System.nanoTime();
        Stack<Clock> stack = this.startTimes;
        Clock ending = stack.pop();
        if (ending.clazz != c) {
            throw new AssertionError((Object)("Asked to end timing for " + c + " but top of stack is " + ending.clazz + ", remaining stack is " + stack));
        }
        ending.accumulateTime(currentNanoTime);
        if (!stack.isEmpty()) {
            Clock restarting = stack.peek();
            restarting.restartClock(currentNanoTime);
        }
        if ((accumulatedTime = ending.accumulatedTime) == 0L) {
            return;
        }
        Profile counter = (Profile)this.profile.get(c);
        if (counter == null && (counter2 = this.profile.putIfAbsent(c, counter = new Profile(c.getName()))) != null) {
            counter = counter2;
        }
        counter.handleCall(accumulatedTime, this.getContext());
    }

    @Deprecated
    public void report() {
        if (!REPORT) {
            return;
        }
        this.report(new TotalTimeComparator(this), new FilterByTime(10000000L), System.err);
    }

    @Deprecated
    public void report(Comparator<Class<?>> reportComparator, Filter filter, PrintStream stream) {
        stream.println("PROFILE REPORT");
        try {
            TreeSet treeSet = new TreeSet(reportComparator);
            treeSet.addAll(this.profile.keySet());
            stream.printf("%8s  %8s %9s %s%n", "msecs", "#calls", "usecs/call", "Class");
            for (Class<?> c : treeSet) {
                Profile p = this.getProfile(c);
                long time = p.totalTime.get();
                int callCount = p.totalCalls.get();
                if (!filter.accepts(p)) continue;
                stream.printf("%8d  %8d  %8d %s%n", TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), callCount, TimeUnit.MICROSECONDS.convert(time / (long)callCount, TimeUnit.NANOSECONDS), c.getSimpleName());
            }
            stream.flush();
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
    }

    public void clear() {
        this.profile.clear();
        this.startTimes.clear();
    }

    @Override
    public Profile getProfile(Class<?> c) {
        Profile result = (Profile)this.profile.get(c);
        if (result == null) {
            AnalysisContext.logError("Unexpected null profile for " + c.getName(), new NullPointerException());
            result = new Profile(c.getName());
            Profile tmp = this.profile.putIfAbsent(c, result);
            if (tmp != null) {
                return tmp;
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.startTag("FindBugsProfile");
        xmlOutput.stopTag(false);
        TreeSet treeSet = new TreeSet(new TotalTimeComparator(this));
        treeSet.addAll(this.profile.keySet());
        long totalTime = 0L;
        for (Profile p : this.profile.values()) {
            totalTime += p.totalTime.get();
        }
        long accumulatedTime = 0L;
        for (Class c : treeSet) {
            Profile p = this.getProfile(c);
            if (p == null) continue;
            p.writeXML(xmlOutput);
            if ((accumulatedTime += p.totalTime.get()) <= 3L * totalTime / 4L) continue;
            break;
        }
        xmlOutput.closeTag("FindBugsProfile");
    }

    @NonNull
    Set<Class<?>> getTargetClasses() {
        return this.profile.keySet();
    }

    @NonNull
    Collection<Profile> getProfiles() {
        return this.profile.values();
    }

    @CheckReturnValue
    boolean contains(@NonNull Class<?> targetClass) {
        return this.profile.containsKey(Objects.requireNonNull(targetClass));
    }

    public static class TotalCallsComparator
    extends ClassNameComparator {
        public TotalCallsComparator(IProfiler p) {
            super(p);
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            int calls2;
            Profile profile1 = this.profiler.getProfile(c1);
            Profile profile2 = this.profiler.getProfile(c2);
            int calls1 = profile1.totalCalls.get();
            if (calls1 < (calls2 = profile2.totalCalls.get())) {
                return 1;
            }
            if (calls1 > calls2) {
                return -1;
            }
            return super.compare(c1, c2);
        }
    }

    public static class TimePerCallComparator
    extends ClassNameComparator {
        public TimePerCallComparator(IProfiler p) {
            super(p);
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            long time2;
            Profile profile1 = this.profiler.getProfile(c1);
            Profile profile2 = this.profiler.getProfile(c2);
            long time1 = profile1.totalTime.get() / (long)profile1.totalCalls.get();
            if (time1 < (time2 = profile2.totalTime.get() / (long)profile2.totalCalls.get())) {
                return 1;
            }
            if (time1 > time2) {
                return -1;
            }
            return super.compare(c1, c2);
        }
    }

    public static class TotalTimeComparator
    extends ClassNameComparator {
        public TotalTimeComparator(IProfiler p) {
            super(p);
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            long v2;
            long v1 = this.profiler.getProfile(c1).totalTime.get();
            if (v1 < (v2 = this.profiler.getProfile(c2).totalTime.get())) {
                return 1;
            }
            if (v1 > v2) {
                return -1;
            }
            return super.compare(c1, c2);
        }
    }

    public static class ClassNameComparator
    implements Comparator<Class<?>> {
        protected final IProfiler profiler;

        public ClassNameComparator(IProfiler p) {
            this.profiler = p;
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            try {
                return c1.getSimpleName().compareTo(c2.getSimpleName());
            }
            catch (RuntimeException e) {
                AnalysisContext.logError("Error comparing " + c1 + " and " + c2, e);
                int i1 = System.identityHashCode(c1);
                int i2 = System.identityHashCode(c2);
                if (i1 < i2) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        }
    }

    static class Clock {
        final Class<?> clazz;
        long startTimeNanos;
        long accumulatedTime;

        Clock(Class<?> clazz, long currentNanoTime) {
            this.clazz = clazz;
            this.startTimeNanos = currentNanoTime;
        }

        void accumulateTime(long currentNanoTime) {
            this.accumulatedTime += currentNanoTime - this.startTimeNanos;
        }

        void restartClock(long currentNanoTime) {
            this.startTimeNanos = currentNanoTime;
        }
    }

    public static class Profile
    implements XMLWriteable {
        final AtomicLong totalTime = new AtomicLong();
        final AtomicInteger totalCalls = new AtomicInteger();
        final AtomicLong maxTime = new AtomicLong();
        final AtomicLong totalSquareMicroseconds = new AtomicLong();
        private final String className;
        Object maxContext;

        public Profile(String className) {
            this.className = className;
        }

        public void handleCall(long nanoTime, Object context) {
            this.totalCalls.incrementAndGet();
            this.totalTime.addAndGet(nanoTime);
            long oldMax = this.maxTime.get();
            if (nanoTime > oldMax) {
                this.maxTime.compareAndSet(oldMax, nanoTime);
                if (MAX_CONTEXT) {
                    this.maxContext = context;
                }
            }
            long microseconds = TimeUnit.MICROSECONDS.convert(nanoTime, TimeUnit.NANOSECONDS);
            this.totalSquareMicroseconds.addAndGet(microseconds * microseconds);
        }

        public long getTotalTime() {
            return this.totalTime.get();
        }

        @Override
        public void writeXML(XMLOutput xmlOutput) throws IOException {
            long time = this.totalTime.get();
            int callCount = this.totalCalls.get();
            long maxTimeMicros = TimeUnit.MICROSECONDS.convert(this.maxTime.get(), TimeUnit.NANOSECONDS);
            long timeMillis = TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS);
            long timeMicros = TimeUnit.MICROSECONDS.convert(time, TimeUnit.NANOSECONDS);
            long averageTimeMicros = timeMicros / (long)callCount;
            long totalSquareMicros = this.totalSquareMicroseconds.get();
            long averageSquareMicros = totalSquareMicros / (long)callCount;
            long timeVariance = averageSquareMicros - averageTimeMicros * averageTimeMicros;
            long timeStandardDeviation = (long)Math.sqrt(timeVariance);
            if (timeMillis > 10L) {
                xmlOutput.startTag("ClassProfile");
                xmlOutput.addAttribute("name", this.className);
                xmlOutput.addAttribute("totalMilliseconds", String.valueOf(timeMillis));
                xmlOutput.addAttribute("invocations", String.valueOf(callCount));
                xmlOutput.addAttribute("avgMicrosecondsPerInvocation", String.valueOf(averageTimeMicros));
                xmlOutput.addAttribute("maxMicrosecondsPerInvocation", String.valueOf(maxTimeMicros));
                if (this.maxContext != null) {
                    xmlOutput.addAttribute("maxContext", String.valueOf(this.maxContext));
                }
                xmlOutput.addAttribute("standardDeviationMicrosecondsPerInvocation", String.valueOf(timeStandardDeviation));
                xmlOutput.stopTag(true);
            }
        }
    }

    public static class FilterByCalls
    implements Filter {
        private final int minCalls;

        public FilterByCalls(int minCalls) {
            this.minCalls = minCalls;
        }

        @Override
        public boolean accepts(Profile p) {
            int totalCalls = p.totalCalls.get();
            return totalCalls >= this.minCalls;
        }
    }

    public static class FilterByTimePerCall
    implements Filter {
        private final long minNanoSeconds;

        public FilterByTimePerCall(long minNanoSeconds) {
            this.minNanoSeconds = minNanoSeconds;
        }

        @Override
        public boolean accepts(Profile p) {
            int totalCalls = p.totalCalls.get();
            long time = p.totalTime.get();
            return time / (long)totalCalls >= this.minNanoSeconds;
        }
    }

    public static class FilterByTime
    implements Filter {
        private final long minNanoSeconds;

        public FilterByTime(long minNanoSeconds) {
            this.minNanoSeconds = minNanoSeconds;
        }

        @Override
        public boolean accepts(Profile p) {
            long time = p.totalTime.get();
            return time >= this.minNanoSeconds;
        }
    }

    public static interface Filter {
        public boolean accepts(Profile var1);
    }
}

