/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.calendar.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeSerializer
extends JsonSerializer<Date> {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.US);

    public DateTimeSerializer() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.format.setTimeZone(timeZone);
    }

    public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeString(this.format.format(value));
    }
}

