/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.calendar.impl;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.social.google.api.calendar.EventListQueryBuilder;
import org.springframework.social.google.api.calendar.EventPage;
import org.springframework.social.google.api.calendar.OrderBy;
import org.springframework.social.google.api.impl.ApiEnumSerializer;
import org.springframework.social.google.api.query.impl.ApiQueryBuilderImpl;
import org.springframework.web.client.RestTemplate;

public class EventListQueryBuilderImpl
extends ApiQueryBuilderImpl<EventListQueryBuilder, EventPage>
implements EventListQueryBuilder {
    private final Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    public EventListQueryBuilderImpl(String urlTemplate, String calendarId, Class<EventPage> type, RestTemplate restTemplate) {
        super(MessageFormat.format(urlTemplate, EventListQueryBuilderImpl.encode(calendarId)), type, restTemplate);
    }

    private Date makeDate(int year, int month, int day) {
        this.utcCalendar.setTimeInMillis(0L);
        this.utcCalendar.set(year, month - 1, day);
        return this.utcCalendar.getTime();
    }

    @Override
    public EventListQueryBuilder fromPage(String pageToken) {
        return (EventListQueryBuilder)super.fromPage(pageToken == null ? null : EventListQueryBuilderImpl.encode(pageToken));
    }

    @Override
    public EventListQueryBuilder timeMin(Date timeMin) {
        return (EventListQueryBuilder)this.appendQueryParam("timeMin", timeMin);
    }

    @Override
    public EventListQueryBuilder timeMin(int year, int month, int day) {
        return this.timeMin(this.makeDate(year, month, day));
    }

    @Override
    public EventListQueryBuilder timeMax(Date timeMax) {
        return (EventListQueryBuilder)this.appendQueryParam("timeMax", timeMax);
    }

    @Override
    public EventListQueryBuilder timeMax(int year, int month, int day) {
        return this.timeMax(this.makeDate(year, month, day));
    }

    @Override
    public EventListQueryBuilder orderBy(OrderBy orderBy) {
        return (EventListQueryBuilder)this.appendQueryParam("orderBy", ApiEnumSerializer.enumToString(orderBy));
    }

    @Override
    public EventListQueryBuilder singleEvents(boolean singleEvents) {
        return (EventListQueryBuilder)this.appendQueryParam("singleEvents", singleEvents);
    }

    @Override
    public EventListQueryBuilder showDeleted(boolean showDeleted) {
        return (EventListQueryBuilder)this.appendQueryParam("showDeleted", showDeleted);
    }

    @Override
    public EventListQueryBuilder showHiddenInvitations(boolean showHiddenInvitations) {
        return (EventListQueryBuilder)this.appendQueryParam("showHiddenInvitations", showHiddenInvitations);
    }

    @Override
    public EventListQueryBuilder timeZone(TimeZone timeZone) {
        return (EventListQueryBuilder)this.appendQueryParam("timeZone", timeZone.getID());
    }

    @Override
    public EventListQueryBuilder updatedMin(Date updatedMin) {
        return (EventListQueryBuilder)this.appendQueryParam("updatedMin", updatedMin);
    }

    @Override
    public EventListQueryBuilder alwaysIncludeEmail(boolean alwaysIncludeEmail) {
        return (EventListQueryBuilder)this.appendQueryParam("alwaysIncludeEmail", alwaysIncludeEmail);
    }

    @Override
    public EventListQueryBuilder iCalUid(String iCalUid) {
        return (EventListQueryBuilder)this.appendQueryParam("iCalUid", EventListQueryBuilderImpl.encode(iCalUid));
    }

    @Override
    public EventListQueryBuilder maxAttendees(int maxAttendees) {
        return (EventListQueryBuilder)this.appendQueryParam("maxAttendees", maxAttendees);
    }
}

