/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import com.github.springtestdbunit.DbUnitRunner;
import com.github.springtestdbunit.DbUnitTestContext;
import com.github.springtestdbunit.bean.DatabaseDataSourceConnectionFactoryBean;
import com.github.springtestdbunit.dataset.DataSetLoader;
import com.github.springtestdbunit.dataset.FlatXmlDataSetLoader;
import com.github.springtestdbunit.operation.DatabaseOperationLookup;
import com.github.springtestdbunit.operation.DefaultDatabaseOperationLookup;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.dbunit.database.IDatabaseConnection;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitRule
implements MethodRule {
    private static DbUnitRunner runner = new DbUnitRunner();
    private static Map<Class<?>, TestClassFields> fields = new HashMap();
    private IDatabaseConnection connection;
    private DataSetLoader dataSetLoader;
    private DatabaseOperationLookup databaseOperationLookup;

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        DbUnitTestContextAdapter context = new DbUnitTestContextAdapter(method, target);
        return new DbUnitStatement(context, base);
    }

    public void setDataSource(DataSource dataSource) {
        this.connection = DatabaseDataSourceConnectionFactoryBean.newConnection(dataSource);
    }

    public void setDatabaseConnection(IDatabaseConnection connection) {
        this.connection = connection;
    }

    public void setDataSetLoader(DataSetLoader dataSetLoader) {
        this.dataSetLoader = dataSetLoader;
    }

    public void setDatabaseOperationLookup(DatabaseOperationLookup databaseOperationLookup) {
        this.databaseOperationLookup = databaseOperationLookup;
    }

    private static TestClassFields getTestClassFields(Class<?> testClass) {
        TestClassFields fields = DbUnitRule.fields.get(testClass);
        if (fields == null) {
            fields = new TestClassFields(testClass);
            DbUnitRule.fields.put(testClass, fields);
        }
        return fields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassFields {
        private Map<Class<?>, Set<Field>> fieldMap = new HashMap();
        private Class<?> testClass;

        public TestClassFields(Class<?> testClass) {
            this.testClass = testClass;
        }

        private Set<Field> getFields(final Class<?> type) {
            if (this.fieldMap.containsKey(type)) {
                return this.fieldMap.get(type);
            }
            final HashSet<Field> fields = new HashSet<Field>();
            ReflectionUtils.doWithFields(this.testClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    if (type.isAssignableFrom(field.getType())) {
                        field.setAccessible(true);
                        fields.add(field);
                    }
                }
            });
            this.fieldMap.put(type, fields);
            return fields;
        }

        public <T> T get(Class<T> type, Object obj) {
            Set<Field> fields = this.getFields(type);
            switch (fields.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    try {
                        return (T)fields.iterator().next().get(obj);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to read field of type " + type.getName() + " from " + this.testClass, e);
                    }
                }
            }
            throw new IllegalStateException("Unable to read a single value from multiple fields of type " + type.getName() + " from " + this.testClass);
        }
    }

    private class DbUnitStatement
    extends Statement {
        private Statement nextStatement;
        private DbUnitTestContextAdapter testContext;

        public DbUnitStatement(DbUnitTestContextAdapter testContext, Statement nextStatement) {
            this.testContext = testContext;
            this.nextStatement = nextStatement;
        }

        public void evaluate() throws Throwable {
            runner.beforeTestMethod(this.testContext);
            try {
                this.nextStatement.evaluate();
            }
            catch (Throwable e) {
                this.testContext.setTestException(e);
            }
            runner.afterTestMethod(this.testContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DbUnitTestContextAdapter
    implements DbUnitTestContext {
        private FrameworkMethod method;
        private Object target;
        private Throwable testException;

        public DbUnitTestContextAdapter(FrameworkMethod method, Object target) {
            this.method = method;
            this.target = target;
        }

        private boolean hasField(Class<?> type) {
            return this.getField(type) != null;
        }

        private <T> T getField(Class<T> type) {
            return DbUnitRule.getTestClassFields(this.getTestClass()).get(type, this.target);
        }

        @Override
        public IDatabaseConnection getConnection() {
            if (DbUnitRule.this.connection == null) {
                if (this.hasField(IDatabaseConnection.class)) {
                    DbUnitRule.this.connection = this.getField(IDatabaseConnection.class);
                } else if (this.hasField(DataSource.class)) {
                    DbUnitRule.this.connection = DatabaseDataSourceConnectionFactoryBean.newConnection(this.getField(DataSource.class));
                } else {
                    throw new IllegalStateException("Unable to locate database connection for DbUnitRule.  Ensure that a DataSource or IDatabaseConnection is available as a private member of your test");
                }
            }
            return DbUnitRule.this.connection;
        }

        @Override
        public DataSetLoader getDataSetLoader() {
            if (DbUnitRule.this.dataSetLoader == null) {
                if (this.hasField(DataSetLoader.class)) {
                    DbUnitRule.this.dataSetLoader = this.getField(DataSetLoader.class);
                } else {
                    DbUnitRule.this.dataSetLoader = new FlatXmlDataSetLoader();
                }
            }
            return DbUnitRule.this.dataSetLoader;
        }

        @Override
        public DatabaseOperationLookup getDatbaseOperationLookup() {
            if (DbUnitRule.this.databaseOperationLookup == null) {
                if (this.hasField(DatabaseOperationLookup.class)) {
                    DbUnitRule.this.databaseOperationLookup = this.getField(DatabaseOperationLookup.class);
                } else {
                    DbUnitRule.this.databaseOperationLookup = new DefaultDatabaseOperationLookup();
                }
            }
            return DbUnitRule.this.databaseOperationLookup;
        }

        @Override
        public Class<?> getTestClass() {
            return this.target.getClass();
        }

        @Override
        public Method getTestMethod() {
            return this.method.getMethod();
        }

        @Override
        public Throwable getTestException() {
            return this.testException;
        }

        public void setTestException(Throwable e) {
            this.testException = e;
        }
    }
}

