/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import com.github.springtestdbunit.DbUnitTestContext;
import com.github.springtestdbunit.DbUnitTestExecutionListener;
import com.github.springtestdbunit.annotation.DatabaseOperation;
import com.github.springtestdbunit.annotation.DatabaseSetup;
import com.github.springtestdbunit.annotation.DatabaseTearDown;
import com.github.springtestdbunit.annotation.ExpectedDatabase;
import com.github.springtestdbunit.assertion.DatabaseAssertion;
import com.github.springtestdbunit.dataset.DataSetLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbUnitRunner {
    private static final Log logger = LogFactory.getLog(DbUnitTestExecutionListener.class);

    DbUnitRunner() {
    }

    public void beforeTestMethod(DbUnitTestContext testContext) throws Exception {
        Collection<DatabaseSetup> annotations = this.getAnnotations(testContext, DatabaseSetup.class);
        this.setupOrTeardown(testContext, true, AnnotationAttributes.get(annotations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(DbUnitTestContext testContext) throws Exception {
        try {
            this.verifyExpected(testContext, this.getAnnotations(testContext, ExpectedDatabase.class));
            Collection<DatabaseTearDown> annotations = this.getAnnotations(testContext, DatabaseTearDown.class);
            try {
                this.setupOrTeardown(testContext, false, AnnotationAttributes.get(annotations));
            }
            catch (RuntimeException e) {
                if (testContext.getTestException() == null) {
                    throw e;
                }
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Unable to throw database cleanup exception due to existing test error", (Throwable)e);
                }
            }
        }
        finally {
            testContext.getConnection().close();
        }
    }

    private <T extends Annotation> Collection<T> getAnnotations(DbUnitTestContext testContext, Class<T> annotationType) {
        ArrayList annotations = new ArrayList();
        this.addAnnotationToList(annotations, AnnotationUtils.findAnnotation(testContext.getTestClass(), annotationType));
        this.addAnnotationToList(annotations, AnnotationUtils.findAnnotation((Method)testContext.getTestMethod(), annotationType));
        return annotations;
    }

    private <T extends Annotation> void addAnnotationToList(List<T> annotations, T annotation) {
        if (annotation != null) {
            annotations.add(annotation);
        }
    }

    private void verifyExpected(DbUnitTestContext testContext, Collection<ExpectedDatabase> annotations) throws Exception {
        if (testContext.getTestException() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping @DatabaseTest expectation due to test exception " + testContext.getTestException().getClass()));
            }
            return;
        }
        IDatabaseConnection connection = testContext.getConnection();
        IDataSet actualDataSet = connection.createDataSet();
        for (ExpectedDatabase annotation : annotations) {
            IDataSet expectedDataSet = this.loadDataset(testContext, annotation.value());
            if (expectedDataSet == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Veriftying @DatabaseTest expectation using " + annotation.value()));
            }
            DatabaseAssertion assertion = annotation.assertionMode().getDatabaseAssertion();
            assertion.assertEquals(expectedDataSet, actualDataSet);
        }
    }

    private IDataSet loadDataset(DbUnitTestContext testContext, String dataSetLocation) throws Exception {
        DataSetLoader dataSetLoader = testContext.getDataSetLoader();
        if (StringUtils.hasLength((String)dataSetLocation)) {
            IDataSet dataSet = dataSetLoader.loadDataSet(testContext.getTestClass(), dataSetLocation);
            Assert.notNull((Object)dataSet, (String)("Unable to load dataset from \"" + dataSetLocation + "\" using " + dataSetLoader.getClass()));
            return dataSet;
        }
        return null;
    }

    private void setupOrTeardown(DbUnitTestContext testContext, boolean isSetup, Collection<AnnotationAttributes> annotations) throws Exception {
        IDatabaseConnection connection = testContext.getConnection();
        DatabaseOperation lastOperation = null;
        for (AnnotationAttributes annotation : annotations) {
            for (String dataSetLocation : annotation.getValue()) {
                DatabaseOperation operation = annotation.getType();
                org.dbunit.operation.DatabaseOperation dbUnitDatabaseOperation = this.getDbUnitDatabaseOperation(testContext, operation, lastOperation);
                IDataSet dataSet = this.loadDataset(testContext, dataSetLocation);
                if (dataSet == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing " + (isSetup ? "Setup" : "Teardown") + " of @DatabaseTest using " + (Object)((Object)operation) + " on " + dataSetLocation));
                }
                dbUnitDatabaseOperation.execute(connection, dataSet);
                lastOperation = operation;
            }
        }
    }

    private org.dbunit.operation.DatabaseOperation getDbUnitDatabaseOperation(DbUnitTestContext testContext, DatabaseOperation operation, DatabaseOperation lastOperation) {
        org.dbunit.operation.DatabaseOperation databaseOperation;
        if (operation == DatabaseOperation.CLEAN_INSERT && lastOperation == DatabaseOperation.CLEAN_INSERT) {
            operation = DatabaseOperation.INSERT;
        }
        Assert.state(((databaseOperation = testContext.getDatbaseOperationLookup().get(operation)) != null ? 1 : 0) != 0, (String)("The databse operation " + (Object)((Object)operation) + " is not supported"));
        return databaseOperation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationAttributes {
        private DatabaseOperation type;
        private String[] value;

        public AnnotationAttributes(Annotation annotation) {
            Assert.state((annotation instanceof DatabaseSetup || annotation instanceof DatabaseTearDown ? 1 : 0) != 0, (String)"Only DatabaseSetup and DatabaseTearDown annotations are supported");
            Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
            this.type = (DatabaseOperation)((Object)attributes.get("type"));
            this.value = (String[])attributes.get("value");
        }

        public DatabaseOperation getType() {
            return this.type;
        }

        public String[] getValue() {
            return this.value;
        }

        public static <T extends Annotation> Collection<AnnotationAttributes> get(Collection<T> annotations) {
            ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>();
            for (Annotation annotation : annotations) {
                annotationAttributes.add(new AnnotationAttributes(annotation));
            }
            return annotationAttributes;
        }
    }
}

