/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit.bean;

import java.util.HashMap;
import java.util.Map;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.filter.IColumnFilter;
import org.springframework.util.Assert;

public class DatabaseConfigBean {
    private static final Map<String, DatabaseConfig.ConfigProperty> CONFIG_PROPERTIES = new HashMap<String, DatabaseConfig.ConfigProperty>();
    private DatabaseConfig databaseConfig = new DatabaseConfig();

    public IStatementFactory getStatementFactory() {
        return (IStatementFactory)this.getProperty("statementFactory", "http://www.dbunit.org/properties/statementFactory");
    }

    public void setStatementFactory(IStatementFactory statementFactory) {
        this.setProperty("statementFactory", "http://www.dbunit.org/properties/statementFactory", statementFactory);
    }

    public IResultSetTableFactory getResultsetTableFactory() {
        return (IResultSetTableFactory)this.getProperty("resultSetTableFactory", "http://www.dbunit.org/properties/resultSetTableFactory");
    }

    public void setResultsetTableFactory(IResultSetTableFactory resultSetTableFactory) {
        this.setProperty("resultSetTableFactory", "http://www.dbunit.org/properties/resultSetTableFactory", resultSetTableFactory);
    }

    public IDataTypeFactory getDatatypeFactory() {
        return (IDataTypeFactory)this.getProperty("dataTypeFactory", "http://www.dbunit.org/properties/datatypeFactory");
    }

    public void setDatatypeFactory(IDataTypeFactory dataTypeFactory) {
        this.setProperty("dataTypeFactory", "http://www.dbunit.org/properties/datatypeFactory", dataTypeFactory);
    }

    public String getEscapePattern() {
        return (String)this.getProperty("escapePattern", "http://www.dbunit.org/properties/escapePattern");
    }

    public void setEscapePattern(String escapePattern) {
        this.setProperty("escapePattern", "http://www.dbunit.org/properties/escapePattern", escapePattern);
    }

    public String[] getTableType() {
        return (String[])this.getProperty("tableTable", "http://www.dbunit.org/properties/tableType");
    }

    public void setTableType(String[] tableTable) {
        this.setProperty("tableTable", "http://www.dbunit.org/properties/tableType", tableTable);
    }

    public IColumnFilter getPrimaryKeyFilter() {
        return (IColumnFilter)this.getProperty("primaryKeyFilter", "http://www.dbunit.org/properties/primaryKeyFilter");
    }

    public void setPrimaryKeyFilter(IColumnFilter primaryKeyFilter) {
        this.setProperty("primaryKeyFilter", "http://www.dbunit.org/properties/primaryKeyFilter", primaryKeyFilter);
    }

    public Integer getBatchSize() {
        return (Integer)this.getProperty("batchSize", "http://www.dbunit.org/properties/batchSize");
    }

    public void setBatchSize(Integer batchSize) {
        this.setProperty("batchSize", "http://www.dbunit.org/properties/batchSize", batchSize);
    }

    public Integer getFetchSize() {
        return (Integer)this.getProperty("fetchSize", "http://www.dbunit.org/properties/fetchSize");
    }

    public void setFetchSize(Integer fetchSize) {
        this.setProperty("fetchSize", "http://www.dbunit.org/properties/fetchSize", fetchSize);
    }

    public IMetadataHandler getMetadataHandler() {
        return (IMetadataHandler)this.getProperty("metadataHandler", "http://www.dbunit.org/properties/metadataHandler");
    }

    public void setMetadataHandler(IMetadataHandler metadataHandler) {
        this.setProperty("metadataHandler", "http://www.dbunit.org/properties/metadataHandler", metadataHandler);
    }

    public Boolean getCaseSensitiveTableNames() {
        return (Boolean)this.getProperty("caseSensitiveTableNames", "http://www.dbunit.org/features/caseSensitiveTableNames");
    }

    public void setCaseSensitiveTableNames(Boolean caseSensitiveTableNames) {
        this.setProperty("caseSensitiveTableNames", "http://www.dbunit.org/features/caseSensitiveTableNames", caseSensitiveTableNames);
    }

    public Boolean getQualifiedTableNames() {
        return (Boolean)this.getProperty("qualifiedTableNames", "http://www.dbunit.org/features/qualifiedTableNames");
    }

    public void setQualifiedTableNames(Boolean qualifiedTableNames) {
        this.setProperty("qualifiedTableNames", "http://www.dbunit.org/features/qualifiedTableNames", qualifiedTableNames);
    }

    public Boolean getBatchedStatements() {
        return (Boolean)this.getProperty("batchedStatements", "http://www.dbunit.org/features/batchedStatements");
    }

    public void setBatchedStatements(Boolean batchedStatements) {
        this.setProperty("batchedStatements", "http://www.dbunit.org/features/batchedStatements", batchedStatements);
    }

    public Boolean getDatatypeWarning() {
        return (Boolean)this.getProperty("datatypeWarning", "http://www.dbunit.org/features/datatypeWarning");
    }

    public void setDatatypeWarning(Boolean datatypeWarning) {
        this.setProperty("datatypeWarning", "http://www.dbunit.org/features/datatypeWarning", datatypeWarning);
    }

    public Boolean getSkipOracleRecyclebinTables() {
        return (Boolean)this.getProperty("skipOracleRecyclebinTables", "http://www.dbunit.org/features/skipOracleRecycleBinTables");
    }

    public void setSkipOracleRecyclebinTables(Boolean skipOracleRecyclebinTables) {
        this.setProperty("skipOracleRecyclebinTables", "http://www.dbunit.org/features/skipOracleRecycleBinTables", skipOracleRecyclebinTables);
    }

    public Boolean getAllowEmptyFields() {
        return (Boolean)this.getProperty("allowEmptyFields", "http://www.dbunit.org/features/allowEmptyFields");
    }

    public void setAllowEmptyFields(Boolean allowEmptyFields) {
        this.setProperty("allowEmptyFields", "http://www.dbunit.org/features/allowEmptyFields", allowEmptyFields);
    }

    private Object getProperty(String propertyName, String dataConfigPropertyName) {
        try {
            return this.databaseConfig.getProperty(dataConfigPropertyName);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to get " + propertyName, ex);
        }
    }

    private void setProperty(String propertyName, String dataConfigPropertyName, Object value) {
        DatabaseConfig.ConfigProperty configProperty = CONFIG_PROPERTIES.get(dataConfigPropertyName);
        Assert.state((configProperty != null ? 1 : 0) != 0, (String)("Unsupported config property " + dataConfigPropertyName + " for " + propertyName));
        if (!configProperty.isNullable()) {
            Assert.notNull((Object)value, (String)(propertyName + " cannot be null"));
        }
        if (value != null) {
            Assert.isInstanceOf((Class)configProperty.getPropertyType(), (Object)value, (String)("Unable to set " + propertyName + " "));
        }
        this.databaseConfig.setProperty(dataConfigPropertyName, value);
    }

    public void apply(DatabaseConfig databaseConfig) {
        for (DatabaseConfig.ConfigProperty configProperty : DatabaseConfig.ALL_PROPERTIES) {
            String name = configProperty.getProperty();
            Object value = this.databaseConfig.getProperty(name);
            if (!configProperty.isNullable() && (configProperty.isNullable() || value == null)) continue;
            databaseConfig.setProperty(name, value);
        }
    }

    static {
        for (DatabaseConfig.ConfigProperty configProperty : DatabaseConfig.ALL_PROPERTIES) {
            CONFIG_PROPERTIES.put(configProperty.getProperty(), configProperty);
        }
    }
}

