/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefanbirkner.fakesftpserver.lambda;

import com.github.marschall.memoryfilesystem.MemoryFileSystemBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;

public class FakeSftpServer {
    private static final SimpleFileVisitor<Path> DELETE_FILES_AND_DIRECTORIES = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (dir.getParent() != null) {
                Files.delete(dir);
            }
            return super.postVisitDirectory(dir, exc);
        }
    };
    private static final Random RANDOM = new Random();
    private final FileSystem fileSystem;
    private SshServer server;
    private boolean withSftpServerFinished = false;
    private final Map<String, String> usernamesAndPasswords = new HashMap<String, String>();

    public static void withSftpServer(ExceptionThrowingConsumer testCode) throws Exception {
        try (FileSystem fileSystem = FakeSftpServer.createFileSystem();){
            FakeSftpServer server = new FakeSftpServer(fileSystem);
            try (Closeable closeServer = server.start(0);){
                testCode.accept(server);
                server.withSftpServerFinished = true;
            }
        }
    }

    private FakeSftpServer(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public int getPort() {
        this.verifyWithSftpServerIsNotFinished("call getPort()");
        return this.server.getPort();
    }

    public void setPort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port cannot be set to " + port + " because only ports between 1 and 65535 are valid.");
        }
        this.verifyWithSftpServerIsNotFinished("set port");
        this.restartServer(port);
    }

    public FakeSftpServer addUser(String username, String password) {
        this.usernamesAndPasswords.put(username, password);
        return this;
    }

    private void restartServer(int port) {
        try {
            this.server.stop();
            this.start(port);
        }
        catch (IOException e) {
            throw new IllegalStateException("The SFTP server cannot be restarted.", e);
        }
    }

    public void putFile(String path, String content, Charset encoding) throws IOException {
        byte[] contentAsBytes = content.getBytes(encoding);
        this.putFile(path, contentAsBytes);
    }

    public void putFile(String path, byte[] content) throws IOException {
        this.verifyWithSftpServerIsNotFinished("upload file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        this.ensureDirectoryOfPathExists(pathAsObject);
        Files.write(pathAsObject, content, new OpenOption[0]);
    }

    public void putFile(String path, InputStream is) throws IOException {
        this.verifyWithSftpServerIsNotFinished("upload file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        this.ensureDirectoryOfPathExists(pathAsObject);
        Files.copy(is, pathAsObject, new CopyOption[0]);
    }

    public void createDirectory(String path) throws IOException {
        this.verifyWithSftpServerIsNotFinished("create directory");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        Files.createDirectories(pathAsObject, new FileAttribute[0]);
    }

    public void createDirectories(String ... paths) throws IOException {
        for (String path : paths) {
            this.createDirectory(path);
        }
    }

    public String getFileContent(String path, Charset encoding) throws IOException {
        byte[] content = this.getFileContent(path);
        return new String(content, encoding);
    }

    public byte[] getFileContent(String path) throws IOException {
        this.verifyWithSftpServerIsNotFinished("download file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        return Files.readAllBytes(pathAsObject);
    }

    public boolean existsFile(String path) {
        this.verifyWithSftpServerIsNotFinished("check existence of file");
        Path pathAsObject = this.fileSystem.getPath(path, new String[0]);
        return Files.exists(pathAsObject, new LinkOption[0]) && !Files.isDirectory(pathAsObject, new LinkOption[0]);
    }

    public void deleteAllFilesAndDirectories() throws IOException {
        for (Path directory : this.fileSystem.getRootDirectories()) {
            Files.walkFileTree(directory, DELETE_FILES_AND_DIRECTORIES);
        }
    }

    private static FileSystem createFileSystem() throws IOException {
        return MemoryFileSystemBuilder.newLinux().build("FakeSftpServer-" + RANDOM.nextInt());
    }

    private Closeable start(int port) throws IOException {
        SshServer server = SshServer.setUpDefaultServer();
        server.setPort(port);
        server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        server.setPasswordAuthenticator(this::authenticate);
        server.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        server.setFileSystemFactory((FileSystemFactory)new DoNotCloseFactory(this.fileSystem));
        server.start();
        this.server = server;
        return () -> this.server.close();
    }

    private boolean authenticate(String username, String password, ServerSession session) {
        return this.usernamesAndPasswords.isEmpty() || Objects.equals(this.usernamesAndPasswords.get(username), password);
    }

    private void ensureDirectoryOfPathExists(Path path) throws IOException {
        Path directory = path.getParent();
        if (directory != null && !directory.equals(path.getRoot())) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
    }

    private void verifyWithSftpServerIsNotFinished(String task) {
        if (this.withSftpServerFinished) {
            throw new IllegalStateException("Failed to " + task + " because withSftpServer is already finished.");
        }
    }

    private static class DoNotCloseFactory
    implements FileSystemFactory {
        final FileSystem fileSystem;

        DoNotCloseFactory(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        public Path getUserHomeDir(SessionContext session) {
            return null;
        }

        public FileSystem createFileSystem(SessionContext session) {
            return new DoNotClose(this.fileSystem);
        }
    }

    private static class DoNotClose
    extends FileSystem {
        final FileSystem fileSystem;

        DoNotClose(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public FileSystemProvider provider() {
            return this.fileSystem.provider();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isOpen() {
            return this.fileSystem.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return this.fileSystem.isReadOnly();
        }

        @Override
        public String getSeparator() {
            return this.fileSystem.getSeparator();
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return this.fileSystem.getRootDirectories();
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return this.fileSystem.getFileStores();
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return this.fileSystem.supportedFileAttributeViews();
        }

        @Override
        public Path getPath(String first, String ... more) {
            return this.fileSystem.getPath(first, more);
        }

        @Override
        public PathMatcher getPathMatcher(String syntaxAndPattern) {
            return this.fileSystem.getPathMatcher(syntaxAndPattern);
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return this.fileSystem.getUserPrincipalLookupService();
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return this.fileSystem.newWatchService();
        }
    }

    public static interface ExceptionThrowingConsumer {
        public void accept(FakeSftpServer var1) throws Exception;
    }
}

