/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.rules.ExternalResource;

public abstract class PrintStreamLog
extends ExternalResource {
    private static final boolean NO_AUTO_FLUSH = false;
    private static final String ENCODING = "UTF-8";
    private final ByteArrayOutputStream log = new ByteArrayOutputStream();
    private PrintStream originalStream;

    protected void before() throws Throwable {
        this.originalStream = this.getOriginalStream();
        TeeOutputStream tee = new TeeOutputStream((OutputStream)this.originalStream, (OutputStream)this.log);
        PrintStream wrappedLog = new PrintStream((OutputStream)tee, false, ENCODING);
        this.setStream(wrappedLog);
    }

    protected void after() {
        this.setStream(this.originalStream);
    }

    protected abstract PrintStream getOriginalStream();

    protected abstract void setStream(PrintStream var1);

    public void clear() {
        this.log.reset();
    }

    public String getLog() {
        try {
            return this.log.toString(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

