/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.contrib.java.lang.system.LogMode;
import org.junit.rules.ExternalResource;

public abstract class PrintStreamLog
extends ExternalResource {
    private static final boolean NO_AUTO_FLUSH = false;
    private static final String ENCODING = "UTF-8";
    private final ByteArrayOutputStream log = new ByteArrayOutputStream();
    private final LogMode mode;
    private PrintStream originalStream;

    protected PrintStreamLog(LogMode mode) {
        if (mode == null) {
            throw new NullPointerException("The LogMode is missing.");
        }
        this.mode = mode;
    }

    protected void before() throws Throwable {
        this.originalStream = this.getOriginalStream();
        PrintStream wrappedStream = new PrintStream(this.getNewStream(), false, ENCODING);
        this.setStream(wrappedStream);
    }

    private OutputStream getNewStream() throws UnsupportedEncodingException {
        switch (this.mode) {
            case LOG_AND_WRITE_TO_STREAM: {
                return new TeeOutputStream((OutputStream)this.originalStream, (OutputStream)this.log);
            }
            case LOG_ONLY: {
                return this.log;
            }
        }
        throw new IllegalArgumentException("The LogMode " + (Object)((Object)this.mode) + " is not supported");
    }

    protected void after() {
        this.setStream(this.originalStream);
    }

    protected abstract PrintStream getOriginalStream();

    protected abstract void setStream(PrintStream var1);

    public void clear() {
        this.log.reset();
    }

    public String getLog() {
        try {
            return this.log.toString(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

