/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import com.eaio.util.lang.Hex;
import com.eaio.uuid.MACAddressParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class UUIDGen {
    private static long lastTime = Long.MIN_VALUE;
    private static String macAddress = null;
    private static long clockSeqAndNode = Long.MIN_VALUE;

    private UUIDGen() {
    }

    public static long getClockSeqAndNode() {
        return clockSeqAndNode;
    }

    public static long newTime() {
        return UUIDGen.createTime(System.currentTimeMillis());
    }

    public static synchronized long createTime(long currentTimeMillis) {
        long timeMillis = currentTimeMillis * 10000L + 122192928000000000L;
        if (timeMillis > lastTime) {
            lastTime = timeMillis;
        } else {
            timeMillis = ++lastTime;
        }
        long time = timeMillis << 32;
        time |= (timeMillis & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeMillis >> 48 & 0xFFFL;
    }

    public static String getMACAddress() {
        return macAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFirstLineOfCommand(String ... commands) throws IOException {
        Process p = null;
        BufferedReader reader = null;
        try {
            p = Runtime.getRuntime().exec(commands);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()), 128);
            String string = reader.readLine();
            return string;
        }
        finally {
            if (p != null) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
                try {
                    p.getErrorStream().close();
                }
                catch (IOException ex) {}
                try {
                    p.getOutputStream().close();
                }
                catch (IOException ex) {}
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Class.forName("java.net.InterfaceAddress");
            macAddress = Class.forName("com.eaio.uuid.UUIDGen$HardwareAddressLookup").newInstance().toString();
        }
        catch (ExceptionInInitializerError err) {
        }
        catch (ClassNotFoundException ex) {
        }
        catch (LinkageError err) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (macAddress == null) {
            Process p = null;
            BufferedReader in = null;
            try {
                String osname = System.getProperty("os.name", "");
                String osver = System.getProperty("os.version", "");
                if (osname.startsWith("Windows")) {
                    p = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
                } else if (osname.startsWith("Solaris") || osname.startsWith("SunOS")) {
                    if (osver.startsWith("5.11")) {
                        p = Runtime.getRuntime().exec(new String[]{"dladm", "show-phys", "-m"}, null);
                    } else {
                        String hostName = UUIDGen.getFirstLineOfCommand("uname", "-n");
                        if (hostName != null) {
                            p = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", hostName}, null);
                        }
                    }
                } else if (new File("/usr/sbin/lanscan").exists()) {
                    p = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
                } else if (new File("/sbin/ifconfig").exists()) {
                    p = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
                }
                if (p != null) {
                    in = new BufferedReader(new InputStreamReader(p.getInputStream()), 128);
                    String l = null;
                    while ((l = in.readLine()) != null && ((macAddress = MACAddressParser.parse(l)) == null || Hex.parseShort(macAddress) == 255)) {
                    }
                }
            }
            catch (SecurityException ex) {
            }
            catch (IOException ex) {
            }
            finally {
                if (p != null) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {}
                    }
                    try {
                        p.getErrorStream().close();
                    }
                    catch (IOException ex) {}
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException ex) {}
                    p.destroy();
                }
            }
        }
        if (macAddress != null) {
            clockSeqAndNode |= Hex.parseLong(macAddress);
        } else {
            try {
                byte[] local = InetAddress.getLocalHost().getAddress();
                clockSeqAndNode |= (long)(local[0] << 24) & 0xFF000000L;
                clockSeqAndNode |= (long)(local[1] << 16 & 0xFF0000);
                clockSeqAndNode |= (long)(local[2] << 8 & 0xFF00);
                clockSeqAndNode |= (long)(local[3] & 0xFF);
            }
            catch (UnknownHostException ex) {
                clockSeqAndNode |= (long)(Math.random() * 2.147483647E9);
            }
        }
        clockSeqAndNode |= (long)(Math.random() * 16383.0) << 48;
    }

    static class HardwareAddressLookup {
        HardwareAddressLookup() {
        }

        public String toString() {
            String out;
            block3: {
                out = null;
                try {
                    Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                    if (ifs == null) break block3;
                    while (ifs.hasMoreElements()) {
                        NetworkInterface iface = ifs.nextElement();
                        byte[] hardware = iface.getHardwareAddress();
                        if (hardware == null || hardware.length != 6 || hardware[1] == -1) continue;
                        out = Hex.append((Appendable)new StringBuilder(36), hardware).toString();
                        break;
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            return out;
        }
    }
}

