/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.NewStubMappingTask;
import com.github.tomakehurst.wiremock.admin.NotFoundAdminTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.ResetTask;
import com.github.tomakehurst.wiremock.admin.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.RootRedirectTask;
import com.github.tomakehurst.wiremock.admin.RootTask;
import com.github.tomakehurst.wiremock.admin.SocketDelayTask;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import wiremock.com.google.common.collect.BiMap;
import wiremock.com.google.common.collect.ImmutableBiMap;

public class AdminTasks {
    private static final BiMap<RequestSpec, Class<? extends AdminTask>> TASKS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put(RequestSpec.requestSpec(RequestMethod.GET, "/"), RootTask.class)).put(RequestSpec.requestSpec(RequestMethod.GET, ""), RootRedirectTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/reset"), ResetTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/mappings/new"), NewStubMappingTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/scenarios/reset"), ResetScenariosTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/mappings/reset"), ResetToDefaultMappingsTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/requests/count"), GetRequestCountTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/requests/find"), FindRequestsTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/socket-delay"), SocketDelayTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/settings"), GlobalSettingsUpdateTask.class)).build();

    public static AdminTask taskFor(RequestMethod method, String path) {
        Class taskClass = (Class)TASKS.get(RequestSpec.requestSpec(method, path));
        if (taskClass == null) {
            return new NotFoundAdminTask();
        }
        try {
            return (AdminTask)taskClass.newInstance();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, AdminTask.class);
        }
    }

    public static RequestSpec requestSpecForTask(Class<? extends AdminTask> taskClass) {
        return (RequestSpec)TASKS.inverse().get(taskClass);
    }
}

