/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonDeserializer;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.ImmutableMultimap;
import wiremock.com.google.common.collect.Iterables;
import wiremock.com.google.common.collect.Lists;
import wiremock.com.google.common.collect.Multimap;
import wiremock.com.google.common.collect.Sets;

@JsonSerialize(using=HttpHeadersJsonSerializer.class)
@JsonDeserialize(using=HttpHeadersJsonDeserializer.class)
public class HttpHeaders {
    private final Multimap<CaseInsensitiveKey, String> headers;

    public HttpHeaders() {
        this.headers = ImmutableMultimap.of();
    }

    public HttpHeaders(HttpHeader ... headers) {
        this(ImmutableList.copyOf(headers));
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        ImmutableMultimap.Builder<CaseInsensitiveKey, String> builder = ImmutableMultimap.builder();
        for (HttpHeader header : headers) {
            builder.putAll(this.caseInsensitive(header.key()), (Iterable<String>)header.values());
        }
        this.headers = builder.build();
    }

    public HttpHeaders(HttpHeaders headers) {
        this(headers.all());
    }

    public static HttpHeaders noHeaders() {
        return new HttpHeaders();
    }

    public HttpHeader getHeader(String key) {
        if (!this.headers.containsKey(this.caseInsensitive(key))) {
            return HttpHeader.absent(key);
        }
        Collection<String> values = this.headers.get(this.caseInsensitive(key));
        return new HttpHeader(key, values);
    }

    public ContentTypeHeader getContentTypeHeader() {
        HttpHeader header = this.getHeader("Content-Type");
        if (header.isPresent()) {
            return new ContentTypeHeader(this.getHeader("Content-Type").firstValue());
        }
        return ContentTypeHeader.absent();
    }

    public Collection<HttpHeader> all() {
        ArrayList<HttpHeader> httpHeaderList = Lists.newArrayList();
        for (CaseInsensitiveKey key : this.headers.keySet()) {
            httpHeaderList.add(new HttpHeader(key.key, this.headers.get(key)));
        }
        return httpHeaderList;
    }

    public Set<String> keys() {
        return Sets.newHashSet(Iterables.transform(this.headers.keySet(), new Function<CaseInsensitiveKey, String>(){

            @Override
            public String apply(CaseInsensitiveKey input) {
                return input.key;
            }
        }));
    }

    public static HttpHeaders copyOf(HttpHeaders source) {
        return new HttpHeaders(source);
    }

    public int size() {
        return this.headers.asMap().size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)o;
        return !(this.headers != null ? !this.headers.equals(that.headers) : that.headers != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }

    private CaseInsensitiveKey caseInsensitive(String key) {
        return new CaseInsensitiveKey(key);
    }

    private static class CaseInsensitiveKey {
        final String key;

        CaseInsensitiveKey(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaseInsensitiveKey that = (CaseInsensitiveKey)o;
            return !(this.key != null ? !this.key.toLowerCase().equals(that.key.toLowerCase()) : that.key != null);
        }

        public int hashCode() {
            return this.key != null ? this.key.toLowerCase().hashCode() : 0;
        }
    }
}

