/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Iterables;
import wiremock.org.apache.http.Header;
import wiremock.org.apache.http.HttpEntityEnclosingRequest;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.HttpResponse;
import wiremock.org.apache.http.client.HttpClient;
import wiremock.org.apache.http.client.methods.HttpDelete;
import wiremock.org.apache.http.client.methods.HttpGet;
import wiremock.org.apache.http.client.methods.HttpHead;
import wiremock.org.apache.http.client.methods.HttpOptions;
import wiremock.org.apache.http.client.methods.HttpPost;
import wiremock.org.apache.http.client.methods.HttpPut;
import wiremock.org.apache.http.client.methods.HttpTrace;
import wiremock.org.apache.http.client.methods.HttpUriRequest;
import wiremock.org.apache.http.entity.StringEntity;

public class ProxyResponseRenderer
implements ResponseRenderer {
    private static final int MINUTES = 60000;
    private final HttpClient client;

    public ProxyResponseRenderer(ProxySettings proxySettings) {
        this.client = proxySettings != null ? HttpClientFactory.createClient(1000, 300000, proxySettings) : HttpClientFactory.createClient(1000, 300000);
    }

    public ProxyResponseRenderer() {
        this(ProxySettings.NO_PROXY);
    }

    @Override
    public Response render(ResponseDefinition responseDefinition) {
        HttpUriRequest httpRequest = ProxyResponseRenderer.getHttpRequestFor(responseDefinition);
        ProxyResponseRenderer.addRequestHeaders(httpRequest, responseDefinition);
        httpRequest.removeHeaders("Host");
        try {
            ProxyResponseRenderer.addBodyIfPostOrPut(httpRequest, responseDefinition);
            HttpResponse httpResponse = this.client.execute(httpRequest);
            return Response.response().status(httpResponse.getStatusLine().getStatusCode()).headers(this.headersFrom(httpResponse)).body(HttpClientUtils.getEntityAsByteArrayAndCloseStream(httpResponse)).fromProxy(true).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpHeaders headersFrom(HttpResponse httpResponse) {
        return new HttpHeaders(Iterables.transform(Arrays.asList(httpResponse.getAllHeaders()), new Function<Header, HttpHeader>(){

            @Override
            public HttpHeader apply(Header header) {
                return new HttpHeader(header.getName(), header.getValue());
            }
        }));
    }

    private static HttpUriRequest getHttpRequestFor(ResponseDefinition response) {
        RequestMethod method = response.getOriginalRequest().getMethod();
        String url = response.getProxyUrl();
        LocalNotifier.notifier().info("Proxying: " + (Object)((Object)method) + " " + url);
        switch (method) {
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpDelete(url);
            }
            case HEAD: {
                return new HttpHead(url);
            }
            case OPTIONS: {
                return new HttpOptions(url);
            }
            case TRACE: {
                return new HttpTrace(url);
            }
        }
        throw new RuntimeException("Cannot create HttpMethod for " + (Object)((Object)method));
    }

    private static void addRequestHeaders(HttpRequest httpRequest, ResponseDefinition response) {
        Request originalRequest = response.getOriginalRequest();
        for (String key : originalRequest.getAllHeaderKeys()) {
            if (!ProxyResponseRenderer.headerShouldBeTransferred(key)) continue;
            String value = originalRequest.getHeader(key);
            httpRequest.addHeader(key, value);
        }
    }

    private static boolean headerShouldBeTransferred(String key) {
        return !ImmutableList.of("content-length", "transfer-encoding").contains(key.toLowerCase());
    }

    private static void addBodyIfPostOrPut(HttpRequest httpRequest, ResponseDefinition response) throws UnsupportedEncodingException {
        Request originalRequest = response.getOriginalRequest();
        if (originalRequest.getMethod() == RequestMethod.POST || originalRequest.getMethod() == RequestMethod.PUT) {
            HttpEntityEnclosingRequest requestWithEntity = (HttpEntityEnclosingRequest)httpRequest;
            ContentTypeHeader contentTypeHeader = originalRequest.contentTypeHeader();
            String body = originalRequest.getBodyAsString();
            if (contentTypeHeader.isPresent()) {
                requestWithEntity.setEntity(new StringEntity(body, contentTypeHeader.mimeTypePart(), contentTypeHeader.encodingPart().isPresent() ? contentTypeHeader.encodingPart().get() : "utf-8"));
            } else {
                requestWithEntity.setEntity(new StringEntity(body, "text/plain", "utf-8"));
            }
        }
    }
}

