/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.impl;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.MappingProvider;
import com.jayway.jsonpath.spi.Mode;
import com.jayway.jsonpath.spi.impl.AbstractJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import wiremock.org.codehaus.jackson.JsonGenerator;
import wiremock.org.codehaus.jackson.map.ObjectMapper;
import wiremock.org.codehaus.jackson.map.type.CollectionType;
import wiremock.org.codehaus.jackson.type.JavaType;

public class JacksonProvider
extends AbstractJsonProvider
implements MappingProvider {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Mode getMode() {
        return Mode.STRICT;
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        try {
            return this.objectMapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(Reader jsonReader) throws InvalidJsonException {
        try {
            return this.objectMapper.readValue(jsonReader, Object.class);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream) throws InvalidJsonException {
        try {
            return this.objectMapper.readValue(jsonStream, Object.class);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGenerator = this.objectMapper.getJsonFactory().createJsonGenerator((Writer)writer);
            this.objectMapper.writeValue(jsonGenerator, obj);
            writer.close();
            return writer.getBuffer().toString();
        }
        catch (IOException e) {
            throw new InvalidJsonException();
        }
    }

    @Override
    public Map<String, Object> createMap() {
        return new HashMap<String, Object>();
    }

    @Override
    public List<Object> createList() {
        return new LinkedList<Object>();
    }

    @Override
    public <T> T convertValue(Object fromValue, Class<T> toValueType) throws IllegalArgumentException {
        return (T)this.objectMapper.convertValue(fromValue, toValueType);
    }

    @Override
    public <T extends Collection<E>, E> T convertValue(Object fromValue, Class<T> collectionType, Class<E> elementType) throws IllegalArgumentException {
        CollectionType colType = this.objectMapper.getTypeFactory().constructCollectionType(collectionType, elementType);
        return (T)((Collection)this.objectMapper.convertValue(fromValue, (JavaType)colType));
    }
}

