/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.matching.ValuePattern;
import java.util.Collection;
import java.util.List;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.Iterables;
import wiremock.com.google.common.collect.Lists;

public class HttpHeader {
    private final String key;
    private final List<String> values;

    public HttpHeader(String key, String ... values) {
        this.key = key;
        this.values = Lists.newArrayList(values);
    }

    public HttpHeader(String key, Collection<String> values) {
        this.key = key;
        this.values = Lists.newArrayList(values);
    }

    public static HttpHeader httpHeader(String key, String ... values) {
        return new HttpHeader(key, values);
    }

    public static HttpHeader absent(String key) {
        return new HttpHeader(key, new String[0]);
    }

    public static HttpHeader copyOf(HttpHeader header) {
        return new HttpHeader(header.key(), header.values());
    }

    public boolean isPresent() {
        return this.values.size() > 0;
    }

    public String key() {
        return this.key;
    }

    public String firstValue() {
        this.checkPresent();
        return this.values.get(0);
    }

    public List<String> values() {
        this.checkPresent();
        return this.values;
    }

    private void checkPresent() {
        Preconditions.checkState(this.isPresent(), "No value for header " + this.key);
    }

    public boolean isSingleValued() {
        return this.values.size() == 1;
    }

    public boolean containsValue(String expectedValue) {
        return this.values.contains(expectedValue);
    }

    public boolean hasValueMatching(ValuePattern valuePattern) {
        return valuePattern.nullSafeIsAbsent() && !this.isPresent() || this.anyValueMatches(valuePattern);
    }

    private boolean anyValueMatches(final ValuePattern valuePattern) {
        return Iterables.any(this.values, new Predicate<String>(){

            @Override
            public boolean apply(String headerValue) {
                return valuePattern.isMatchFor(headerValue);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String value : this.values) {
            sb.append(this.key).append(": ").append(value).append("\n");
        }
        return sb.toString();
    }
}

