/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.Log4jNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.Options;
import java.io.IOException;
import java.io.StringWriter;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.joptsimple.OptionParser;
import wiremock.joptsimple.OptionSet;

public class CommandLineOptions
implements Options {
    private static final String HELP = "help";
    private static final String RECORD_MAPPINGS = "record-mappings";
    private static final String PROXY_ALL = "proxy-all";
    private static final String PROXY_VIA = "proxy-via";
    private static final String PORT = "port";
    private static final String BIND_ADDRESS = "bind-address";
    private static final String HTTPS_PORT = "https-port";
    private static final String HTTPS_KEYSTORE = "https-keystore";
    private static final String VERBOSE = "verbose";
    private static final String ENABLE_BROWSER_PROXYING = "enable-browser-proxying";
    private static final String DISABLE_REQUEST_JOURNAL = "no-request-journal";
    private static final String ROOT_DIR = "root-dir";
    private final OptionSet optionSet;
    private String helpText;

    public CommandLineOptions(String ... args) {
        OptionParser optionParser = new OptionParser();
        optionParser.accepts(PORT, "The port number for the server to listen on").withRequiredArg();
        optionParser.accepts(HTTPS_PORT, "If this option is present WireMock will enable HTTPS on the specified port").withRequiredArg();
        optionParser.accepts(BIND_ADDRESS, "The IP to listen connections").withRequiredArg();
        optionParser.accepts(HTTPS_KEYSTORE, "Path to an alternative keystore for HTTPS. Must have a password of \"password\".").withRequiredArg();
        optionParser.accepts(PROXY_ALL, "Will create a proxy mapping for /* to the specified URL").withRequiredArg();
        optionParser.accepts(PROXY_VIA, "Specifies a proxy server to use when routing proxy mapped requests").withRequiredArg();
        optionParser.accepts(RECORD_MAPPINGS, "Enable recording of all (non-admin) requests as mapping files");
        optionParser.accepts(ROOT_DIR, "Specifies path for storing recordings (parent for mappings and __files folders)").withRequiredArg().defaultsTo(".", (String[])new String[0]);
        optionParser.accepts(VERBOSE, "Enable verbose logging to stdout");
        optionParser.accepts(ENABLE_BROWSER_PROXYING, "Allow wiremock to be set as a browser's proxy server");
        optionParser.accepts(DISABLE_REQUEST_JOURNAL, "Disable the request journal (to avoid heap growth when running wiremock for long periods without reset)");
        optionParser.accepts(HELP, "Print this message");
        this.optionSet = optionParser.parse(args);
        this.validate();
        this.captureHelpTextIfRequested(optionParser);
    }

    private void validate() {
        if (this.optionSet.has(HTTPS_KEYSTORE) && !this.optionSet.has(HTTPS_PORT)) {
            throw new IllegalArgumentException("HTTPS port number must be specified if specifying the keystore path");
        }
        if (this.optionSet.has(RECORD_MAPPINGS) && this.optionSet.has(DISABLE_REQUEST_JOURNAL)) {
            throw new IllegalArgumentException("Request journal must be enabled to record stubs");
        }
    }

    private void captureHelpTextIfRequested(OptionParser optionParser) {
        if (this.optionSet.has(HELP)) {
            StringWriter out = new StringWriter();
            try {
                optionParser.printHelpOn(out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.helpText = out.toString();
        }
    }

    public boolean verboseLoggingEnabled() {
        return this.optionSet.has(VERBOSE);
    }

    public boolean recordMappingsEnabled() {
        return this.optionSet.has(RECORD_MAPPINGS);
    }

    private boolean specifiesPortNumber() {
        return this.optionSet.has(PORT);
    }

    @Override
    public int portNumber() {
        if (this.specifiesPortNumber()) {
            return Integer.parseInt((String)this.optionSet.valueOf(PORT));
        }
        return 8080;
    }

    @Override
    public String bindAddress() {
        if (this.optionSet.has(BIND_ADDRESS)) {
            return (String)this.optionSet.valueOf(BIND_ADDRESS);
        }
        return "0.0.0.0";
    }

    @Override
    public HttpsSettings httpsSettings() {
        if (!this.optionSet.has(HTTPS_PORT)) {
            return HttpsSettings.NO_HTTPS;
        }
        if (this.optionSet.has(HTTPS_KEYSTORE)) {
            return new HttpsSettings(this.httpsPortNumber(), (String)this.optionSet.valueOf(HTTPS_KEYSTORE));
        }
        return new HttpsSettings(this.httpsPortNumber());
    }

    private int httpsPortNumber() {
        return Integer.parseInt((String)this.optionSet.valueOf(HTTPS_PORT));
    }

    public boolean help() {
        return this.optionSet.has(HELP);
    }

    public String helpText() {
        return this.helpText;
    }

    public boolean specifiesProxyUrl() {
        return this.optionSet.has(PROXY_ALL);
    }

    public String proxyUrl() {
        return (String)this.optionSet.valueOf(PROXY_ALL);
    }

    @Override
    public boolean browserProxyingEnabled() {
        return this.optionSet.has(ENABLE_BROWSER_PROXYING);
    }

    @Override
    public ProxySettings proxyVia() {
        if (this.optionSet.has(PROXY_VIA)) {
            String proxyVia = (String)this.optionSet.valueOf(PROXY_VIA);
            return ProxySettings.fromString(proxyVia);
        }
        return ProxySettings.NO_PROXY;
    }

    @Override
    public FileSource filesRoot() {
        return new SingleRootFileSource((String)this.optionSet.valueOf(ROOT_DIR));
    }

    @Override
    public Notifier notifier() {
        return new Log4jNotifier();
    }

    @Override
    public boolean requestJournalDisabled() {
        return this.optionSet.has(DISABLE_REQUEST_JOURNAL);
    }

    public String toString() {
        return Joiner.on(", ").withKeyValueSeparator("=").join(ImmutableMap.builder().put(PORT, this.portNumber()).put("https", (Integer)((Object)this.httpsSettings())).put("fileSource", (Integer)((Object)this.filesRoot())).put("proxyVia", (Integer)((Object)this.nullToString(this.proxyVia()))).put("proxyUrl", (Integer)((Object)this.nullToString(this.proxyUrl()))).put("recordMappingsEnabled", (Integer)((Object)Boolean.valueOf(this.recordMappingsEnabled()))).build());
    }

    private String nullToString(Object value) {
        if (value == null) {
            return "(null)";
        }
        return value.toString();
    }
}

