/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import wiremock.com.fasterxml.jackson.databind.util.NameTransformer;
import wiremock.com.fasterxml.jackson.databind.util.TokenBuffer;

public class UnwrappedPropertyHandler {
    protected final ArrayList<SettableBeanProperty> _properties = new ArrayList();

    public void addProperty(SettableBeanProperty property) {
        this._properties.add(property);
    }

    public void renameAll(NameTransformer transformer) {
        ArrayList<SettableBeanProperty> oldProps = new ArrayList<SettableBeanProperty>(this._properties);
        Iterator<SettableBeanProperty> it = oldProps.iterator();
        this._properties.clear();
        while (it.hasNext()) {
            JsonDeserializer<Object> newDeser;
            SettableBeanProperty prop = it.next();
            String newName = transformer.transform(prop.getName());
            JsonDeserializer<Object> deser = (prop = prop.withName(newName)).getValueDeserializer();
            if (deser != null && (newDeser = deser.unwrappingDeserializer(transformer)) != deser) {
                prop = prop.withValueDeserializer(newDeser);
            }
            this._properties.add(prop);
        }
    }

    public Object processUnwrapped(JsonParser originalParser, DeserializationContext ctxt, Object bean, TokenBuffer buffered) throws IOException, JsonProcessingException {
        int len = this._properties.size();
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._properties.get(i);
            JsonParser jp = buffered.asParser();
            jp.nextToken();
            prop.deserializeAndSet(jp, ctxt, bean);
        }
        return bean;
    }
}

