/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.util;

import wiremock.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import wiremock.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import wiremock.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import wiremock.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import wiremock.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;

public class SimpleBeanPropertyDefinition
extends BeanPropertyDefinition {
    protected final AnnotatedMember _member;
    protected final String _name;

    public SimpleBeanPropertyDefinition(AnnotatedMember member) {
        this(member, member.getName());
    }

    public SimpleBeanPropertyDefinition(AnnotatedMember member, String name) {
        this._member = member;
        this._name = name;
    }

    public SimpleBeanPropertyDefinition withName(String newName) {
        if (this._name.equals(newName)) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._member, newName);
    }

    public String getName() {
        return this._name;
    }

    public String getInternalName() {
        return this.getName();
    }

    public boolean isExplicitlyIncluded() {
        return false;
    }

    public boolean hasGetter() {
        return this.getGetter() != null;
    }

    public boolean hasSetter() {
        return this.getSetter() != null;
    }

    public boolean hasField() {
        return this._member instanceof AnnotatedField;
    }

    public boolean hasConstructorParameter() {
        return this._member instanceof AnnotatedParameter;
    }

    public AnnotatedMethod getGetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 0) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    public AnnotatedMethod getSetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 1) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    public AnnotatedField getField() {
        return this._member instanceof AnnotatedField ? (AnnotatedField)this._member : null;
    }

    public AnnotatedParameter getConstructorParameter() {
        return this._member instanceof AnnotatedParameter ? (AnnotatedParameter)this._member : null;
    }

    public AnnotatedMember getAccessor() {
        AnnotatedMember acc = this.getGetter();
        if (acc == null) {
            acc = this.getField();
        }
        return acc;
    }

    public AnnotatedMember getMutator() {
        AnnotatedMember acc = this.getConstructorParameter();
        if (acc == null && (acc = this.getSetter()) == null) {
            acc = this.getField();
        }
        return acc;
    }

    public AnnotatedMember getPrimaryMember() {
        return this._member;
    }
}

