/*
 * Decompiled with CFR 0.152.
 */
package wiremock.joptsimple;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import wiremock.joptsimple.HelpFormatter;
import wiremock.joptsimple.OptionDescriptor;
import wiremock.joptsimple.ParserRules;
import wiremock.joptsimple.internal.Classes;
import wiremock.joptsimple.internal.ColumnarData;
import wiremock.joptsimple.internal.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuiltinHelpFormatter
implements HelpFormatter {
    private ColumnarData grid;

    BuiltinHelpFormatter() {
    }

    @Override
    public String format(Map<String, ? extends OptionDescriptor> options) {
        if (options.isEmpty()) {
            return "No options specified";
        }
        this.grid = new ColumnarData(this.optionHeader(options), "Description");
        Comparator<OptionDescriptor> comparator = new Comparator<OptionDescriptor>(){

            @Override
            public int compare(OptionDescriptor first, OptionDescriptor second) {
                return first.options().iterator().next().compareTo(second.options().iterator().next());
            }
        };
        TreeSet<OptionDescriptor> sorted = new TreeSet<OptionDescriptor>(comparator);
        sorted.addAll(options.values());
        for (OptionDescriptor each : sorted) {
            this.addHelpLineFor(each);
        }
        return this.grid.format();
    }

    private String optionHeader(Map<String, ? extends OptionDescriptor> options) {
        for (OptionDescriptor optionDescriptor : options.values()) {
            if (!optionDescriptor.isRequired()) continue;
            return "Option (* = required)";
        }
        return "Option";
    }

    private void addHelpLineFor(OptionDescriptor descriptor) {
        if (descriptor.acceptsArguments()) {
            if (descriptor.requiresArgument()) {
                this.addHelpLineWithArgument(descriptor, '<', '>');
            } else {
                this.addHelpLineWithArgument(descriptor, '[', ']');
            }
        } else {
            this.addHelpLineFor(descriptor, "");
        }
    }

    void addHelpLineFor(OptionDescriptor descriptor, String additionalInfo) {
        this.grid.addRow(this.createOptionDisplay(descriptor) + additionalInfo, this.createDescriptionDisplay(descriptor));
    }

    private void addHelpLineWithArgument(OptionDescriptor descriptor, char begin, char end) {
        String argDescription = descriptor.argumentDescription();
        String typeIndicator = BuiltinHelpFormatter.typeIndicator(descriptor);
        StringBuilder collector = new StringBuilder();
        if (typeIndicator.length() > 0) {
            collector.append(typeIndicator);
            if (argDescription.length() > 0) {
                collector.append(": ").append(argDescription);
            }
        } else if (argDescription.length() > 0) {
            collector.append(argDescription);
        }
        String helpLine = collector.length() == 0 ? "" : ' ' + Strings.surround(collector.toString(), begin, end);
        this.addHelpLineFor(descriptor, helpLine);
    }

    private String createOptionDisplay(OptionDescriptor descriptor) {
        StringBuilder buffer = new StringBuilder(descriptor.isRequired() ? "* " : "");
        Iterator<String> iter = descriptor.options().iterator();
        while (iter.hasNext()) {
            String option = iter.next();
            buffer.append(option.length() > 1 ? "--" : ParserRules.HYPHEN);
            buffer.append(option);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private String createDescriptionDisplay(OptionDescriptor descriptor) {
        List<?> defaultValues = descriptor.defaultValues();
        if (defaultValues.isEmpty()) {
            return descriptor.description();
        }
        String defaultValuesDisplay = this.createDefaultValuesDisplay(defaultValues);
        return descriptor.description() + ' ' + Strings.surround("default: " + defaultValuesDisplay, '(', ')');
    }

    private String createDefaultValuesDisplay(List<?> defaultValues) {
        return defaultValues.size() == 1 ? defaultValues.get(0).toString() : defaultValues.toString();
    }

    private static String typeIndicator(OptionDescriptor descriptor) {
        String indicator = descriptor.argumentTypeIndicator();
        return indicator == null || String.class.getName().equals(indicator) ? "" : Classes.shortNameOf(indicator);
    }
}

