/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLTestCase
extends TestCase
implements XSLTConstants {
    public XMLTestCase() {
    }

    public XMLTestCase(String name) {
        super(name);
    }

    public Diff compareXML(InputSource control, InputSource test) throws SAXException, IOException {
        return XMLUnit.compareXML(control, test);
    }

    public Diff compareXML(Reader control, Reader test) throws SAXException, IOException {
        return XMLUnit.compareXML(control, test);
    }

    public Diff compareXML(String control, Reader test) throws SAXException, IOException {
        return XMLUnit.compareXML((Reader)new StringReader(control), test);
    }

    public Diff compareXML(Reader control, String test) throws SAXException, IOException {
        return XMLUnit.compareXML(control, (Reader)new StringReader(test));
    }

    public Diff compareXML(String control, String test) throws SAXException, IOException {
        return XMLUnit.compareXML(control, test);
    }

    public Diff compareXML(Document control, Document test) {
        return XMLUnit.compareXML(control, test);
    }

    public void assertXMLEqual(Diff diff, boolean assertion) {
        XMLAssert.assertXMLEqual(diff, assertion);
    }

    public void assertXMLEqual(String msg, Diff diff, boolean assertion) {
        XMLAssert.assertXMLEqual(msg, diff, assertion);
    }

    public void assertXMLIdentical(Diff diff, boolean assertion) {
        XMLAssert.assertXMLIdentical(diff.toString(), diff, assertion);
    }

    public void assertXMLIdentical(String msg, Diff diff, boolean assertion) {
        XMLAssert.assertXMLIdentical(msg, diff, assertion);
    }

    public void assertXMLEqual(InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(control, test);
    }

    public void assertXMLEqual(String control, String test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(control, test);
    }

    public void assertXMLEqual(Document control, Document test) {
        XMLAssert.assertXMLEqual(control, test);
    }

    public void assertXMLEqual(Reader control, Reader test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(control, test);
    }

    public void assertXMLEqual(String err, String control, String test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXMLEqual(String err, InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXMLEqual(String err, Document control, Document test) {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXMLEqual(String err, Reader control, Reader test) throws SAXException, IOException {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXMLNotEqual(InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(control, test);
    }

    public void assertXMLNotEqual(String control, String test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(control, test);
    }

    public void assertXMLNotEqual(Document control, Document test) {
        XMLAssert.assertXMLNotEqual(control, test);
    }

    public void assertXMLNotEqual(Reader control, Reader test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(control, test);
    }

    public void assertXMLNotEqual(String err, InputSource control, InputSource test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(err, control, test);
    }

    public void assertXMLNotEqual(String err, String control, String test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(err, control, test);
    }

    public void assertXMLNotEqual(String err, Document control, Document test) {
        XMLAssert.assertXMLNotEqual(err, control, test);
    }

    public void assertXMLNotEqual(String err, Reader control, Reader test) throws SAXException, IOException {
        XMLAssert.assertXMLNotEqual(err, control, test);
    }

    public void assertXpathsEqual(String controlXpath, String testXpath, InputSource document) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, document);
    }

    public void assertXpathsEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, document);
    }

    public void assertXpathsEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathsEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, control, testXpath, test);
    }

    public void assertXpathsEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathsEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssert.assertXpathsEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathsNotEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, document);
    }

    public void assertXpathsNotEqual(String controlXpath, String testXpath, InputSource control) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, control);
    }

    public void assertXpathsNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathsNotEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, control, testXpath, test);
    }

    public void assertXpathsNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathsNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssert.assertXpathsNotEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathValuesEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, document);
    }

    public void assertXpathValuesEqual(String controlXpath, String testXpath, InputSource control) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, control);
    }

    public void assertXpathValuesEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathValuesEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, control, testXpath, test);
    }

    public void assertXpathValuesEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathValuesEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssert.assertXpathValuesEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathValuesNotEqual(String controlXpath, String testXpath, InputSource control) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, control);
    }

    public void assertXpathValuesNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathValuesNotEqual(String controlXpath, String testXpath, Document document) throws XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, document);
    }

    public void assertXpathValuesNotEqual(String controlXpath, InputSource control, String testXpath, InputSource test) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, control, testXpath, test);
    }

    public void assertXpathValuesNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathValuesNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws XpathException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, InputSource control) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, control);
    }

    public void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, String inXMLString) throws SAXException, IOException, XpathException {
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, inXMLString);
    }

    public void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, Document inDocument) throws XpathException {
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, inDocument);
    }

    public void assertXpathExists(String xPathExpression, InputSource xml) throws IOException, SAXException, XpathException {
        XMLAssert.assertXpathExists(xPathExpression, xml);
    }

    public void assertXpathExists(String xPathExpression, String inXMLString) throws IOException, SAXException, XpathException {
        XMLAssert.assertXpathExists(xPathExpression, inXMLString);
    }

    public void assertXpathExists(String xPathExpression, Document inDocument) throws XpathException {
        XMLAssert.assertXpathExists(xPathExpression, inDocument);
    }

    public void assertXpathNotExists(String xPathExpression, InputSource xml) throws IOException, SAXException, XpathException {
        XMLAssert.assertXpathNotExists(xPathExpression, xml);
    }

    public void assertXpathNotExists(String xPathExpression, String inXMLString) throws IOException, SAXException, XpathException {
        XMLAssert.assertXpathNotExists(xPathExpression, inXMLString);
    }

    public void assertXpathNotExists(String xPathExpression, Document inDocument) throws XpathException {
        XMLAssert.assertXpathNotExists(xPathExpression, inDocument);
    }

    public void assertXMLValid(InputSource xml) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(xml);
    }

    public void assertXMLValid(String xmlString) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(xmlString);
    }

    public void assertXMLValid(InputSource xml, String systemId) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(xml, systemId);
    }

    public void assertXMLValid(String xmlString, String systemId) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(xmlString, systemId);
    }

    public void assertXMLValid(InputSource xml, String systemId, String doctype) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(xml, systemId, doctype);
    }

    public void assertXMLValid(String xmlString, String systemId, String doctype) throws SAXException, ConfigurationException {
        XMLAssert.assertXMLValid(xmlString, systemId, doctype);
    }

    public void assertXMLValid(Validator validator) {
        XMLAssert.assertXMLValid(validator);
    }

    public void assertNodeTestPasses(InputSource xml, NodeTester tester, short nodeType) throws SAXException, IOException {
        XMLAssert.assertNodeTestPasses(xml, tester, nodeType);
    }

    public void assertNodeTestPasses(String xmlString, NodeTester tester, short nodeType) throws SAXException, IOException {
        XMLAssert.assertNodeTestPasses(xmlString, tester, nodeType);
    }

    public void assertNodeTestPasses(NodeTest test, NodeTester tester, short[] nodeTypes, boolean assertion) {
        XMLAssert.assertNodeTestPasses(test, tester, nodeTypes, assertion);
    }
}

