/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.spi.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import wiremock.com.jayway.jsonpath.InvalidJsonException;
import wiremock.com.jayway.jsonpath.spi.Mode;
import wiremock.com.jayway.jsonpath.spi.impl.AbstractJsonProvider;
import wiremock.net.minidev.json.JSONArray;
import wiremock.net.minidev.json.JSONObject;
import wiremock.net.minidev.json.parser.JSONParser;
import wiremock.net.minidev.json.parser.ParseException;

public class JsonSmartJsonProvider
extends AbstractJsonProvider {
    private Mode mode;
    private JSONParser parser;

    public JsonSmartJsonProvider() {
        this(Mode.SLACK);
    }

    public JsonSmartJsonProvider(Mode mode) {
        this.mode = mode;
        this.parser = new JSONParser(mode.intValue());
    }

    @Override
    public Map<String, Object> createMap() {
        return new JSONObject();
    }

    @Override
    public List<Object> createList() {
        return new JSONArray();
    }

    @Override
    public Object parse(String json) {
        try {
            return this.parser.parse(json);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(Reader jsonReader) throws InvalidJsonException {
        try {
            return this.parser.parse(jsonReader);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream) throws InvalidJsonException {
        try {
            return this.parser.parse(new InputStreamReader(jsonStream));
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (obj instanceof Map) {
            return JSONObject.toJSONString((Map)obj);
        }
        if (obj instanceof List) {
            return JSONArray.toJSONString((List)obj);
        }
        throw new UnsupportedOperationException(obj.getClass().getName() + " can not be converted to JSON");
    }

    @Override
    public Mode getMode() {
        return this.mode;
    }
}

