/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.mortbay.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import wiremock.org.mortbay.util.StringUtil;

public class MultiPartOutputStream
extends FilterOutputStream {
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    public static String MULTIPART_MIXED;
    public static String MULTIPART_X_MIXED_REPLACE;
    private String boundary = "jetty" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
    private byte[] boundaryBytes = this.boundary.getBytes(StringUtil.__ISO_8859_1);
    private boolean inPart = false;

    public MultiPartOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
        super.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(StringUtil.__ISO_8859_1));
        this.out.write(__CRLF);
        for (int i = 0; headers != null && i < headers.length; ++i) {
            this.out.write(headers[i].getBytes(StringUtil.__ISO_8859_1));
            this.out.write(__CRLF);
        }
        this.out.write(__CRLF);
    }

    static {
        MULTIPART_MIXED = "multipart/mixed";
        MULTIPART_X_MIXED_REPLACE = "multipart/x-mixed-replace";
        try {
            __CRLF = "\r\n".getBytes(StringUtil.__ISO_8859_1);
            __DASHDASH = "--".getBytes(StringUtil.__ISO_8859_1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

