/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RequestPattern
implements ValueMatcher<Request> {
    private final UrlPattern url;
    private final RequestMethod method;
    private final Map<String, MultiValuePattern> headers;
    private final Map<String, MultiValuePattern> queryParams;
    private final Map<String, StringValuePattern> cookies;
    private final BasicCredentials basicAuthCredentials;
    private final List<StringValuePattern> bodyPatterns;
    private CustomMatcherDefinition customMatcherDefinition;
    private RequestMatcher matcher;
    private final RequestMatcher defaultMatcher = new RequestMatcher(){

        @Override
        public MatchResult match(Request request) {
            return MatchResult.aggregate(RequestPattern.this.url.match(request.getUrl()), RequestPattern.this.method.match(request.getMethod()), RequestPattern.this.allHeadersMatchResult(request), RequestPattern.this.allQueryParamsMatch(request), RequestPattern.this.allCookiesMatch(request), RequestPattern.this.allBodyPatternsMatch(request));
        }

        @Override
        public String getName() {
            return "default";
        }
    };

    public RequestPattern(UrlPattern url, RequestMethod method, Map<String, MultiValuePattern> headers, Map<String, MultiValuePattern> queryParams, Map<String, StringValuePattern> cookies, BasicCredentials basicAuthCredentials, List<StringValuePattern> bodyPatterns, CustomMatcherDefinition customMatcherDefinition) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.queryParams = queryParams;
        this.cookies = cookies;
        this.basicAuthCredentials = basicAuthCredentials;
        this.bodyPatterns = bodyPatterns;
        this.matcher = this.defaultMatcher;
        this.customMatcherDefinition = customMatcherDefinition;
    }

    @JsonCreator
    public RequestPattern(@JsonProperty(value="url") String url, @JsonProperty(value="urlPattern") String urlPattern, @JsonProperty(value="urlPath") String urlPath, @JsonProperty(value="urlPathPattern") String urlPathPattern, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="headers") Map<String, MultiValuePattern> headers, @JsonProperty(value="queryParameters") Map<String, MultiValuePattern> queryParams, @JsonProperty(value="cookies") Map<String, StringValuePattern> cookies, @JsonProperty(value="basicAuth") BasicCredentials basicAuthCredentials, @JsonProperty(value="bodyPatterns") List<StringValuePattern> bodyPatterns, @JsonProperty(value="customMatcher") CustomMatcherDefinition customMatcherDefinition) {
        this(UrlPattern.fromOneOf(url, urlPattern, urlPath, urlPathPattern), method, headers, queryParams, cookies, basicAuthCredentials, bodyPatterns, customMatcherDefinition);
    }

    public RequestPattern(RequestMatcher customMatcher) {
        this(null, null, null, null, null, null, null, null);
        this.matcher = customMatcher;
    }

    public RequestPattern(CustomMatcherDefinition customMatcherDefinition) {
        this(null, null, null, null, null, null, null, customMatcherDefinition);
    }

    @Override
    public MatchResult match(Request request) {
        return this.match(request, Collections.emptyMap());
    }

    public static RequestPattern everything() {
        return RequestPatternBuilder.newRequestPattern(RequestMethod.ANY, WireMock.anyUrl()).build();
    }

    public MatchResult match(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        if (this.customMatcherDefinition != null) {
            RequestMatcherExtension requestMatcher = (RequestMatcherExtension)MoreObjects.firstNonNull((Object)customMatchers.get(this.customMatcherDefinition.getName()), (Object)RequestMatcherExtension.NEVER);
            return requestMatcher.match(request, this.customMatcherDefinition.getParameters());
        }
        return this.matcher.match(request);
    }

    private MatchResult allCookiesMatch(final Request request) {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(this.cookies.entrySet()).transform((Function)new Function<Map.Entry<String, StringValuePattern>, MatchResult>(){

                public MatchResult apply(Map.Entry<String, StringValuePattern> cookiePattern) {
                    Cookie cookie = request.getCookies().get(cookiePattern.getKey());
                    return cookie != null ? cookiePattern.getValue().match(cookie.getValue()) : MatchResult.noMatch();
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    private MatchResult allHeadersMatchResult(final Request request) {
        Map<String, MultiValuePattern> combinedHeaders = this.combineBasicAuthAndOtherHeaders();
        if (combinedHeaders != null && !combinedHeaders.isEmpty()) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(combinedHeaders.entrySet()).transform((Function)new Function<Map.Entry<String, MultiValuePattern>, MatchResult>(){

                public MatchResult apply(Map.Entry<String, MultiValuePattern> headerPattern) {
                    return headerPattern.getValue().match(request.header(headerPattern.getKey()));
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    public Map<String, MultiValuePattern> combineBasicAuthAndOtherHeaders() {
        if (this.basicAuthCredentials == null) {
            return this.headers;
        }
        ImmutableMap combinedHeaders = this.headers;
        ImmutableMap.Builder allHeadersBuilder = ImmutableMap.builder().putAll((Map)MoreObjects.firstNonNull(combinedHeaders, Collections.emptyMap()));
        allHeadersBuilder.put((Object)"Authorization", (Object)this.basicAuthCredentials.asAuthorizationMultiValuePattern());
        combinedHeaders = allHeadersBuilder.build();
        return combinedHeaders;
    }

    private MatchResult allQueryParamsMatch(final Request request) {
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(this.queryParams.entrySet()).transform((Function)new Function<Map.Entry<String, MultiValuePattern>, MatchResult>(){

                public MatchResult apply(Map.Entry<String, MultiValuePattern> queryParamPattern) {
                    return queryParamPattern.getValue().match(request.queryParameter(queryParamPattern.getKey()));
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    private MatchResult allBodyPatternsMatch(final Request request) {
        if (this.bodyPatterns != null && !this.bodyPatterns.isEmpty() && request.getBody() != null) {
            return MatchResult.aggregate((List<MatchResult>)FluentIterable.from(this.bodyPatterns).transform((Function)new Function<StringValuePattern, MatchResult>(){

                public MatchResult apply(StringValuePattern pattern) {
                    return pattern.match(request.getBodyAsString());
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    public boolean isMatchedBy(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        return this.match(request, customMatchers).isExactMatch();
    }

    public String getUrl() {
        return this.urlPatternOrNull(UrlPattern.class, false);
    }

    public String getUrlPattern() {
        return this.urlPatternOrNull(UrlPattern.class, true);
    }

    public String getUrlPath() {
        return this.urlPatternOrNull(UrlPathPattern.class, false);
    }

    public String getUrlPathPattern() {
        return this.urlPatternOrNull(UrlPathPattern.class, true);
    }

    @JsonIgnore
    public UrlPattern getUrlMatcher() {
        return this.url;
    }

    private String urlPatternOrNull(Class<? extends UrlPattern> clazz, boolean regex) {
        return this.url != null && this.url.getClass().equals(clazz) && this.url.isRegex() == regex && this.url.isSpecified() ? this.url.getPattern().getValue() : null;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public Map<String, MultiValuePattern> getHeaders() {
        return this.headers;
    }

    public BasicCredentials getBasicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public Map<String, MultiValuePattern> getQueryParameters() {
        return this.queryParams;
    }

    public Map<String, StringValuePattern> getCookies() {
        return this.cookies;
    }

    public List<StringValuePattern> getBodyPatterns() {
        return this.bodyPatterns;
    }

    public CustomMatcherDefinition getCustomMatcher() {
        return this.customMatcherDefinition;
    }

    @Override
    public String getName() {
        return "requestMatching";
    }

    @Override
    public String getExpected() {
        return this.toString();
    }

    public boolean hasCustomMatcher() {
        return this.matcher != this.defaultMatcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPattern that = (RequestPattern)o;
        return Objects.equal((Object)this.url, (Object)that.url) && Objects.equal((Object)this.method, (Object)that.method) && Objects.equal(this.headers, that.headers) && Objects.equal(this.queryParams, that.queryParams) && Objects.equal(this.cookies, that.cookies) && Objects.equal((Object)this.basicAuthCredentials, (Object)that.basicAuthCredentials) && Objects.equal(this.bodyPatterns, that.bodyPatterns) && Objects.equal((Object)this.customMatcherDefinition, (Object)that.customMatcherDefinition);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.url, this.method, this.headers, this.queryParams, this.cookies, this.basicAuthCredentials, this.bodyPatterns, this.customMatcherDefinition, this.matcher, this.defaultMatcher});
    }

    public String toString() {
        return Json.write(this);
    }

    public static Predicate<Request> thatMatch(final RequestPattern pattern) {
        return new Predicate<Request>(){

            public boolean apply(Request request) {
                return pattern.match(request).isExactMatch();
            }
        };
    }
}

