/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.JsonData;
import com.google.common.base.MoreObjects;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class HandlebarsJsonPathHelper
extends HandlebarsHelper<Object> {
    private final Configuration config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
    private final ParseContext parseContext = JsonPath.using((Configuration)this.config);

    public Object apply(Object input, Options options) throws IOException {
        if (input == null) {
            return "";
        }
        if (options == null || options.param(0, null) == null) {
            return this.handleError("The JSONPath cannot be empty");
        }
        String jsonPathString = (String)options.param(0);
        try {
            DocumentContext jsonDocument = this.getJsonDocument(input, options);
            JsonPath jsonPath = JsonPath.compile((String)jsonPathString, (Predicate[])new Predicate[0]);
            Object result = this.getValue(jsonPath, jsonDocument, options);
            return JsonData.create(result);
        }
        catch (InvalidJsonException e) {
            return this.handleError(input + " is not valid JSON", e.getJson(), e);
        }
        catch (InvalidPathException e) {
            return this.handleError(jsonPathString + " is not a valid JSONPath expression", e);
        }
    }

    private Object getValue(JsonPath jsonPath, DocumentContext jsonDocument, Options options) {
        RenderCache.Key cacheKey;
        RenderCache renderCache = HandlebarsJsonPathHelper.getRenderCache(options);
        Object value = renderCache.get(cacheKey = RenderCache.Key.keyFor(Object.class, jsonPath, jsonDocument));
        if (value == null) {
            Object defaultValue = options.hash != null ? options.hash("default") : null;
            try {
                value = jsonDocument.read(jsonPath);
            }
            catch (Exception e) {
                value = defaultValue;
            }
            if (value == null) {
                value = MoreObjects.firstNonNull((Object)defaultValue, (Object)"");
            }
            renderCache.put(cacheKey, value);
        }
        return value;
    }

    private DocumentContext getJsonDocument(Object json, Options options) {
        RenderCache.Key cacheKey;
        RenderCache renderCache = HandlebarsJsonPathHelper.getRenderCache(options);
        DocumentContext document = (DocumentContext)renderCache.get(cacheKey = RenderCache.Key.keyFor(DocumentContext.class, json));
        if (document == null) {
            document = json instanceof String ? this.parseContext.parse((String)json) : this.parseContext.parse(json);
            renderCache.put(cacheKey, document);
        }
        return document;
    }
}

