/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimeMatchResult;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class EqualToDateTimePattern
extends AbstractDateTimePattern {
    public EqualToDateTimePattern(ZonedDateTime zonedDateTime) {
        super(zonedDateTime);
    }

    public EqualToDateTimePattern(LocalDateTime localDateTime) {
        super(localDateTime);
    }

    public EqualToDateTimePattern(String dateTimeSpec) {
        super(dateTimeSpec);
    }

    public EqualToDateTimePattern(@JsonProperty(value="equalToDateTime") String dateTimeSpec, @JsonProperty(value="actualFormat") String actualDateFormat, @JsonProperty(value="truncateExpected") String truncateExpected, @JsonProperty(value="truncateActual") String truncateActual, @JsonProperty(value="expectedOffset") Integer expectedOffsetAmount, @JsonProperty(value="expectedOffsetUnit") DateTimeUnit expectedOffsetUnit) {
        super(dateTimeSpec, actualDateFormat, truncateExpected, truncateActual, expectedOffsetAmount, expectedOffsetUnit);
    }

    @Override
    protected MatchResult getMatchResult(ZonedDateTime zonedExpected, LocalDateTime localExpected, ZonedDateTime zonedActual, LocalDateTime localActual) {
        return new AbstractDateTimeMatchResult(zonedExpected, localExpected, zonedActual, localActual){

            @Override
            protected boolean matchZonedZoned() {
                return this.zonedActual.isEqual(this.zonedExpected);
            }

            @Override
            protected boolean matchLocalLocal() {
                return this.localActual.isEqual(this.localExpected);
            }

            @Override
            protected boolean matchLocalZoned() {
                return this.zonedActual.toLocalDateTime().isEqual(this.localExpected);
            }
        };
    }

    public String getEqualToDateTime() {
        return this.getValue();
    }
}

