/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.util.List;
import wiremock.net.javacrumbs.jsonunit.core.internal.BasicExceptionFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.ClassUtils;
import wiremock.net.javacrumbs.jsonunit.core.internal.Differences;
import wiremock.net.javacrumbs.jsonunit.core.internal.ExceptionFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.JsonDifference;
import wiremock.net.javacrumbs.jsonunit.core.internal.Opentest4jExceptionFactory;

class ExceptionUtils {
    private static final String ROOT_MESSAGE = "JSON documents are different:\n";
    private static final ExceptionFactory exceptionFactory = ClassUtils.isClassPresent("org.opentest4j.AssertionFailedError") ? new Opentest4jExceptionFactory() : new BasicExceptionFactory();

    ExceptionUtils() {
    }

    static String formatDifferences(String message, Differences differences) {
        return ExceptionUtils.formatDifferences(message, differences.getDifferences());
    }

    static String formatDifferences(String message, List<JsonDifference> differences) {
        StringBuilder builder = new StringBuilder();
        if (!differences.isEmpty()) {
            ExceptionUtils.addHeading(message, builder);
            builder.append(ROOT_MESSAGE);
            for (JsonDifference difference : differences) {
                builder.append(difference.getMessage()).append("\n");
            }
        }
        return builder.toString();
    }

    static AssertionError createException(String message, Differences diffs) {
        return exceptionFactory.createException(message, diffs);
    }

    private static void addHeading(String message, StringBuilder builder) {
        if (message != null && !message.isEmpty()) {
            if (message.startsWith("[") && message.endsWith("] ")) {
                builder.append(message);
            } else {
                builder.append('[').append(message).append("] ");
            }
        }
    }
}

