/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.alpn.openjdk8.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import wiremock.org.eclipse.jetty.alpn.ALPN;
import wiremock.org.eclipse.jetty.alpn.server.ALPNServerConnection;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.ssl.ALPNProcessor;
import wiremock.org.eclipse.jetty.io.ssl.SslConnection;
import wiremock.org.eclipse.jetty.io.ssl.SslHandshakeListener;
import wiremock.org.eclipse.jetty.util.JavaVersion;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;

public class OpenJDK8ServerALPNProcessor
implements ALPNProcessor.Server {
    private static final Logger LOG = Log.getLogger(OpenJDK8ServerALPNProcessor.class);
    private Method alpnSelector;

    @Override
    public void init() {
        if (JavaVersion.VERSION.getPlatform() != 8) {
            throw new IllegalStateException(this + " not applicable for java " + JavaVersion.VERSION);
        }
        try {
            this.alpnSelector = SSLEngine.class.getMethod("setHandshakeApplicationProtocolSelector", BiFunction.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using OpenJDK ALPN APIs instead of Jetty ALPN APIs", new Object[0]);
            }
            return;
        }
        catch (NoSuchMethodException x) {
            LOG.ignore(x);
            if (ALPN.class.getClassLoader() != null) {
                throw new IllegalStateException(ALPN.class.getName() + " must be on JVM boot classpath");
            }
            if (LOG.isDebugEnabled()) {
                ALPN.debug = true;
            }
            return;
        }
    }

    @Override
    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("sun.security.ssl.");
    }

    @Override
    public void configure(SSLEngine sslEngine, Connection connection) {
        if (this.alpnSelector == null) {
            ALPNListener listener = new ALPNListener((ALPNServerConnection)connection);
            connection.addListener(listener);
        } else {
            try {
                ALPNCallback callback = new ALPNCallback((ALPNServerConnection)connection);
                this.alpnSelector.invoke((Object)sslEngine, callback);
            }
            catch (IllegalAccessException | InvocationTargetException x) {
                throw new IllegalStateException(this + " unable to set ALPN selector", x);
            }
        }
    }

    private static class ALPNCallback
    implements BiFunction<SSLEngine, List<String>, String>,
    SslHandshakeListener {
        private final ALPNServerConnection alpnConnection;

        private ALPNCallback(ALPNServerConnection connection) {
            this.alpnConnection = connection;
            ((SslConnection.DecryptedEndPoint)this.alpnConnection.getEndPoint()).getSslConnection().addHandshakeListener(this);
        }

        @Override
        public String apply(SSLEngine engine, List<String> protocols) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("apply {} {}", this.alpnConnection, protocols);
                }
                this.alpnConnection.select(protocols);
                return this.alpnConnection.getProtocol();
            }
            catch (Throwable x) {
                return null;
            }
        }

        @Override
        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS handshake succeeded, protocol={} for {}", protocol, this.alpnConnection);
            }
            if (protocol == null) {
                this.alpnConnection.unsupported();
            }
        }

        @Override
        public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS handshake failed " + this.alpnConnection, failure);
            }
        }
    }

    private static final class ALPNListener
    implements ALPN.ServerProvider,
    Connection.Listener {
        private final ALPNServerConnection alpnConnection;

        private ALPNListener(ALPNServerConnection connection) {
            this.alpnConnection = connection;
        }

        @Override
        public void onOpened(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onOpened {}", this.alpnConnection);
            }
            ALPN.put((SSLEngine)this.alpnConnection.getSSLEngine(), (ALPN.Provider)this);
        }

        @Override
        public void onClosed(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onClosed {}", this.alpnConnection);
            }
            ALPN.remove((SSLEngine)this.alpnConnection.getSSLEngine());
        }

        public void unsupported() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unsupported {}", this.alpnConnection);
            }
            this.alpnConnection.select(Collections.emptyList());
        }

        public String select(List<String> protocols) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("select {} {}", this.alpnConnection, protocols);
            }
            this.alpnConnection.select(protocols);
            return this.alpnConnection.getProtocol();
        }
    }
}

