/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.hc.client5.http.AuthenticationStrategy;
import wiremock.org.apache.hc.client5.http.auth.AuthChallenge;
import wiremock.org.apache.hc.client5.http.auth.AuthScheme;
import wiremock.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import wiremock.org.apache.hc.client5.http.auth.ChallengeType;
import wiremock.org.apache.hc.client5.http.config.RequestConfig;
import wiremock.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.config.Lookup;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultAuthenticationStrategy
implements AuthenticationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthenticationStrategy.class);
    public static final DefaultAuthenticationStrategy INSTANCE = new DefaultAuthenticationStrategy();
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Negotiate", "Kerberos", "NTLM", "Digest", "Basic"));

    @Override
    public List<AuthScheme> select(ChallengeType challengeType, Map<String, AuthChallenge> challenges, HttpContext context) {
        Collection<String> authPrefs;
        Args.notNull(challengeType, "ChallengeType");
        Args.notNull(challenges, "Map of auth challenges");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        String exchangeId = clientContext.getExchangeId();
        ArrayList<AuthScheme> options = new ArrayList<AuthScheme>();
        Lookup<AuthSchemeFactory> registry = clientContext.getAuthSchemeRegistry();
        if (registry == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Auth scheme registry not set in the context", (Object)exchangeId);
            }
            return options;
        }
        RequestConfig config = clientContext.getRequestConfig();
        Collection<String> collection = authPrefs = challengeType == ChallengeType.TARGET ? config.getTargetPreferredAuthSchemes() : config.getProxyPreferredAuthSchemes();
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
            LOG.debug("{} Authentication schemes in the order of preference: {}", (Object)exchangeId, (Object)authPrefs);
        }
        for (String schemeName : authPrefs) {
            AuthChallenge challenge = challenges.get(schemeName.toLowerCase(Locale.ROOT));
            if (challenge != null) {
                AuthSchemeFactory authSchemeFactory = registry.lookup(schemeName);
                if (authSchemeFactory == null) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("{} Authentication scheme {} not supported", (Object)exchangeId, (Object)schemeName);
                    continue;
                }
                AuthScheme authScheme = authSchemeFactory.create(context);
                options.add(authScheme);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("{}, Challenge for {} authentication scheme not available", (Object)exchangeId, (Object)schemeName);
        }
        return options;
    }
}

