/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.http.Request;
import java.net.URI;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.base.Splitter;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.Iterables;

public class UniqueFilenameGenerator {
    public static String generate(Request request, String prefix, String id) {
        return UniqueFilenameGenerator.generate(request, prefix, id, "json");
    }

    public static String generate(Request request, String prefix, String id, String extension) {
        URI uri = URI.create(request.getUrl());
        Iterable<String> uriPathNodes = Splitter.on("/").omitEmptyStrings().split(uri.getPath());
        int nodeCount = Iterables.size(uriPathNodes);
        String pathPart = nodeCount > 0 ? UniqueFilenameGenerator.sanitise(Joiner.on("-").join(FluentIterable.from(uriPathNodes).skip(nodeCount - Math.min(nodeCount, 2)))) : "(root)";
        return prefix + "-" + pathPart + "-" + id + "." + extension;
    }

    private static String sanitise(String input) {
        return input.replaceAll("[,~:/?#\\[\\]@!\\$&'()*+;=]", "_");
    }
}

