/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import wiremock.com.google.common.annotations.VisibleForTesting;
import wiremock.com.google.common.base.MoreObjects;

@JsonPropertyOrder(value={"id", "uuid", "request", "newRequest", "response"})
public class StubMapping {
    public static final int DEFAULT_PRIORITY = 5;
    private UUID uuid = UUID.randomUUID();
    private RequestPattern request;
    private ResponseDefinition response;
    private Integer priority;
    private String scenarioName;
    private String requiredScenarioState;
    private String newScenarioState;
    private Scenario scenario;
    private Map<String, Parameters> postServeActions;
    private long insertionIndex;
    private boolean isTransient = true;
    public static final StubMapping NOT_CONFIGURED = new StubMapping(null, ResponseDefinition.notConfigured());

    public StubMapping(RequestPattern requestPattern, ResponseDefinition response) {
        this.setRequest(requestPattern);
        this.response = response;
    }

    public StubMapping() {
    }

    public static StubMapping buildFrom(String mappingSpecJson) {
        return Json.read(mappingSpecJson, StubMapping.class);
    }

    public static String buildJsonStringFor(StubMapping mapping) {
        return Json.write(mapping);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setId(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getId() {
        return this.uuid;
    }

    @VisibleForTesting
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public RequestPattern getRequest() {
        return MoreObjects.firstNonNull(this.request, RequestPattern.ANYTHING);
    }

    public ResponseDefinition getResponse() {
        return MoreObjects.firstNonNull(this.response, ResponseDefinition.ok());
    }

    public void setRequest(RequestPattern request) {
        this.request = request;
    }

    public void setResponse(ResponseDefinition response) {
        this.response = response;
    }

    public String toString() {
        return Json.write(this);
    }

    @JsonIgnore
    public long getInsertionIndex() {
        return this.insertionIndex;
    }

    @JsonIgnore
    public void setInsertionIndex(long insertionIndex) {
        this.insertionIndex = insertionIndex;
    }

    @JsonIgnore
    public boolean isTransient() {
        return this.isTransient;
    }

    @JsonIgnore
    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    public String getRequiredScenarioState() {
        return this.requiredScenarioState;
    }

    public void setRequiredScenarioState(String requiredScenarioState) {
        this.requiredScenarioState = requiredScenarioState;
    }

    public String getNewScenarioState() {
        return this.newScenarioState;
    }

    public void setNewScenarioState(String newScenarioState) {
        this.newScenarioState = newScenarioState;
    }

    public void updateScenarioStateIfRequired() {
        if (this.isInScenario() && this.modifiesScenarioState()) {
            this.scenario.setState(this.newScenarioState);
        }
    }

    @JsonIgnore
    public Scenario getScenario() {
        return this.scenario;
    }

    @JsonIgnore
    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    @JsonIgnore
    public boolean isInScenario() {
        return this.scenarioName != null;
    }

    @JsonIgnore
    public boolean modifiesScenarioState() {
        return this.newScenarioState != null;
    }

    @JsonIgnore
    public boolean isIndependentOfScenarioState() {
        return !this.isInScenario() || this.requiredScenarioState == null;
    }

    @JsonIgnore
    public boolean requiresCurrentScenarioState() {
        return !this.isIndependentOfScenarioState() && this.requiredScenarioState.equals(this.scenario.getState());
    }

    public int comparePriorityWith(StubMapping otherMapping) {
        int thisPriority = this.priority != null ? this.priority : 5;
        int otherPriority = otherMapping.priority != null ? otherMapping.priority : 5;
        return thisPriority - otherPriority;
    }

    public Map<String, Parameters> getPostServeActions() {
        return this.postServeActions;
    }

    public void setPostServeActions(Map<String, Parameters> postServeActions) {
        this.postServeActions = postServeActions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubMapping that = (StubMapping)o;
        return this.isTransient == that.isTransient && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.request, that.request) && Objects.equals(this.response, that.response) && Objects.equals(this.priority, that.priority) && Objects.equals(this.scenarioName, that.scenarioName) && Objects.equals(this.requiredScenarioState, that.requiredScenarioState) && Objects.equals(this.newScenarioState, that.newScenarioState) && Objects.equals(this.scenario, that.scenario) && Objects.equals(this.postServeActions, that.postServeActions);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.request, this.response, this.priority, this.scenarioName, this.requiredScenarioState, this.newScenarioState, this.scenario, this.postServeActions, this.isTransient);
    }
}

