/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.android;

import ch.qos.logback.classic.android.ASaxEventRecorder;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.android.CommonPathUtil;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class AndroidManifestPropertiesUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAndroidProperties(Context context) throws JoranException {
        ASaxEventRecorder aSaxEventRecorder = new ASaxEventRecorder();
        aSaxEventRecorder.setFilter("-");
        aSaxEventRecorder.setAttributeWatch("manifest");
        StatusManager statusManager = context.getStatusManager();
        InputStream inputStream = Loader.getClassLoaderOfObject((Object)context).getResourceAsStream("AndroidManifest.xml");
        if (inputStream == null) {
            statusManager.add((Status)new WarnStatus("Could not find AndroidManifest.xml", (Object)context));
            return;
        }
        try {
            aSaxEventRecorder.recordEvents(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        context.putProperty("EXT_DIR", CommonPathUtil.getMountedExternalStorageDirectoryPath());
        Map<String, String> map = aSaxEventRecorder.getAttributeWatchValues();
        for (String string : map.keySet()) {
            if (string.equals("android:versionName")) {
                context.putProperty("VERSION_NAME", map.get(string));
                continue;
            }
            if (string.equals("android:versionCode")) {
                context.putProperty("VERSION_CODE", map.get(string));
                continue;
            }
            if (!string.equals("package")) continue;
            context.putProperty("PACKAGE_NAME", map.get(string));
        }
        String string = map.get("package");
        if (string != null && string.length() > 0) {
            context.putProperty("DATA_DIR", CommonPathUtil.getFilesDirectoryPath((String)string));
        } else {
            statusManager.add((Status)new WarnStatus("Package name not found. Some properties cannot be set.", (Object)context));
        }
    }
}

