/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.log4j;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.helpers.Transform;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLayout
extends LayoutBase<ILoggingEvent> {
    private static final int DEFAULT_SIZE = 256;
    private static final int UPPER_LIMIT = 2048;
    private StringBuilder buf = new StringBuilder(256);
    private boolean locationInfo = false;
    private boolean properties = false;

    public void start() {
        super.start();
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setProperties(boolean bl) {
        this.properties = bl;
    }

    public boolean getProperties() {
        return this.properties;
    }

    public String doLayout(ILoggingEvent iLoggingEvent) {
        Object object;
        Object object2;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuilder(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(iLoggingEvent.getLoggerName());
        this.buf.append("\"\r\n");
        this.buf.append("             timestamp=\"");
        this.buf.append(iLoggingEvent.getTimeStamp());
        this.buf.append("\" level=\"");
        this.buf.append(iLoggingEvent.getLevel());
        this.buf.append("\" thread=\"");
        this.buf.append(iLoggingEvent.getThreadName());
        this.buf.append("\">\r\n");
        this.buf.append("  <log4j:message><![CDATA[");
        Transform.appendEscapingCDATA((StringBuilder)this.buf, (String)iLoggingEvent.getFormattedMessage());
        this.buf.append("]]></log4j:message>\r\n");
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy != null) {
            object2 = iThrowableProxy.getStackTraceElementProxyArray();
            this.buf.append("  <log4j:throwable><![CDATA[");
            for (Serializable serializable : object2) {
                this.buf.append('\t');
                this.buf.append(((StackTraceElementProxy)serializable).toString());
                this.buf.append("\r\n");
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo && (object2 = iLoggingEvent.getCallerData()) != null && ((Serializable[])object2).length > 0) {
            object = object2[0];
            this.buf.append("  <log4j:locationInfo class=\"");
            this.buf.append(((StackTraceElement)object).getClassName());
            this.buf.append("\"\r\n");
            this.buf.append("                      method=\"");
            this.buf.append(Transform.escapeTags((String)((StackTraceElement)object).getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(((StackTraceElement)object).getFileName());
            this.buf.append("\" line=\"");
            this.buf.append(((StackTraceElement)object).getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        if (this.getProperties() && (object2 = iLoggingEvent.getMDCPropertyMap()) != null && object2.size() != 0) {
            object = object2.entrySet();
            this.buf.append("  <log4j:properties>");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.buf.append("\r\n    <log4j:data");
                this.buf.append(" name='" + Transform.escapeTags((String)((String)entry.getKey())) + "'");
                this.buf.append(" value='" + Transform.escapeTags((String)((String)entry.getValue())) + "'");
                this.buf.append(" />");
            }
            this.buf.append("\r\n  </log4j:properties>");
        }
        this.buf.append("\r\n</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    public String getContentType() {
        return "text/xml";
    }
}

