/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import uk.org.lidalia.lang.Exceptions;

class OverridableProperties {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private final String propertySourceName;
    private final Properties properties;

    OverridableProperties(String propertySourceName) {
        this.propertySourceName = propertySourceName;
        this.properties = this.getProperties();
    }

    private Properties getProperties() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.propertySourceName + ".properties")).map(OverridableProperties::loadProperties).orElse(EMPTY_PROPERTIES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(InputStream propertyResource) {
        try (InputStream closablePropertyResource = propertyResource;){
            Properties loadedProperties = new Properties();
            loadedProperties.load(closablePropertyResource);
            Properties properties = loadedProperties;
            return properties;
        }
        catch (IOException ioException) {
            return (Properties)Exceptions.throwUnchecked((Throwable)ioException, null);
        }
    }

    String getProperty(String propertyKey, String defaultValue) {
        String propertyFileProperty = this.properties.getProperty(propertyKey, defaultValue);
        return System.getProperty(this.propertySourceName + "." + propertyKey, propertyFileProperty);
    }
}

