/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta;

import com.github.veithen.alta.AbstractProcessMojo;
import com.github.veithen.alta.Context;
import com.github.veithen.alta.template.Template;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractGenerateMojo
extends AbstractProcessMojo {
    @Parameter(required=true)
    private String name;
    @Parameter(required=true)
    private String value;
    @Parameter
    private String separator;

    @Override
    protected final void process(List<Artifact> artifacts) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Template<Context> nameTemplate = AbstractGenerateMojo.compileTemplate(this.name, "name");
        Template<Context> valueTemplate = AbstractGenerateMojo.compileTemplate(this.value, "value");
        HashMap<String, Artifact> nameToArtifact = new HashMap<String, Artifact>();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Artifact artifact : artifacts) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Processing artifact " + artifact.getId()));
            }
            String name = AbstractGenerateMojo.evaluateTemplate(nameTemplate, artifact);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("name = " + name));
            }
            if (name == null) continue;
            String value = AbstractGenerateMojo.evaluateTemplate(valueTemplate, artifact);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("value = " + value));
            }
            if (value == null) continue;
            String currentValue = (String)result.get(name);
            if (currentValue == null) {
                currentValue = value;
            } else {
                if (this.separator == null) {
                    throw new MojoExecutionException("Artifacts " + ((Artifact)nameToArtifact.get(name)).getId() + " and " + artifact.getId() + " map to the same name '" + name + "', but no separator was configured to combine values");
                }
                currentValue = currentValue + this.separator + value;
            }
            nameToArtifact.put(name, artifact);
            result.put(name, currentValue);
        }
        this.process(result);
    }

    protected abstract void process(Map<String, String> var1) throws MojoExecutionException, MojoFailureException;
}

