/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta;

import com.github.veithen.alta.AbstractProcessMojo;
import com.github.veithen.alta.Context;
import com.github.veithen.alta.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="copy", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class CopyMojo
extends AbstractProcessMojo {
    @Parameter(required=true)
    private File outputDirectory;
    @Parameter(required=true)
    private String name;

    @Override
    protected void process(List<Artifact> artifacts) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        Template<Context> nameTemplate = CopyMojo.compileTemplate(this.name, "name");
        for (Artifact artifact : artifacts) {
            String name;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Processing artifact " + artifact.getId()));
            }
            if ((name = CopyMojo.evaluateTemplate(nameTemplate, artifact)) == null) {
                log.debug((CharSequence)"Not copying artifact");
                continue;
            }
            File outputFile = new File(this.outputDirectory, name);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Copying artifact to " + outputFile));
            }
            try {
                FileUtils.copyFile((File)artifact.getFile(), (File)outputFile);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to copy file", (Exception)ex);
            }
        }
    }
}

