/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

class WrappedResource
implements Resource {
    private final Resource m_host;
    private final List<Resource> m_fragments;
    private List<Capability> m_cachedCapabilities = null;
    private List<Requirement> m_cachedRequirements = null;

    public WrappedResource(Resource host, List<Resource> fragments) {
        this.m_host = host;
        this.m_fragments = fragments;
    }

    public Resource getDeclaredResource() {
        return this.m_host;
    }

    public List<Resource> getFragments() {
        return this.m_fragments;
    }

    public List<Capability> getCapabilities(String namespace) {
        if (this.m_cachedCapabilities == null) {
            ArrayList<WrappedCapability> caps = new ArrayList<WrappedCapability>();
            for (Capability cap : this.m_host.getCapabilities(namespace)) {
                caps.add(new WrappedCapability(this, cap));
            }
            if (this.m_fragments != null) {
                for (Resource fragment : this.m_fragments) {
                    for (Capability cap : fragment.getCapabilities(namespace)) {
                        if (cap.getNamespace().equals("osgi.identity")) continue;
                        caps.add(new WrappedCapability(this, cap));
                    }
                }
            }
            this.m_cachedCapabilities = Collections.unmodifiableList(caps);
        }
        return this.m_cachedCapabilities;
    }

    public List<Requirement> getRequirements(String namespace) {
        if (this.m_cachedRequirements == null) {
            ArrayList<WrappedRequirement> reqs = new ArrayList<WrappedRequirement>();
            for (Requirement req : this.m_host.getRequirements(null)) {
                reqs.add(new WrappedRequirement(this, req));
            }
            if (this.m_fragments != null) {
                for (Resource fragment : this.m_fragments) {
                    for (Requirement req : fragment.getRequirements(null)) {
                        if (req.getNamespace().equals("osgi.wiring.host") || req.getNamespace().equals("osgi.ee")) continue;
                        reqs.add(new WrappedRequirement(this, req));
                    }
                }
            }
            this.m_cachedRequirements = Collections.unmodifiableList(reqs);
        }
        return this.m_cachedRequirements;
    }

    public String toString() {
        return this.m_host.toString();
    }
}

