/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.ResolutionException;

public abstract class SystemModule
extends Module {
    private final Map<Thread, ModuleContainerAdaptor.ContainerEvent> forStop = new HashMap<Thread, ModuleContainerAdaptor.ContainerEvent>(2);

    public SystemModule(ModuleContainer container) {
        super(new Long(0L), "System Bundle", container, EnumSet.of(Module.Settings.AUTO_START, Module.Settings.USE_ACTIVATION_POLICY), new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() throws BundleException {
        this.getRevisions().getContainer().checkAdminPermission(this.getBundle(), "execute");
        boolean lockedStarted = false;
        this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
        try {
            this.getContainer().getAdaptor().initBegin();
            lockedStarted = true;
            this.checkValid();
            if (ACTIVE_SET.contains((Object)this.getState())) {
                return;
            }
            this.getRevisions().getContainer().open();
            if (this.getState().equals((Object)Module.State.INSTALLED)) {
                ResolutionReport report;
                this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                lockedStarted = false;
                try {
                    report = this.getRevisions().getContainer().resolve(Arrays.asList(this), true);
                }
                finally {
                    this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
                    lockedStarted = true;
                }
                this.checkValid();
                ResolutionException e = report.getResolutionException();
                if (e != null && e.getCause() instanceof BundleException) {
                    throw (BundleException)e.getCause();
                }
                if (ACTIVE_SET.contains((Object)this.getState())) {
                    return;
                }
                if (this.getState().equals((Object)Module.State.INSTALLED)) {
                    String reportMessage = report.getResolutionReportMessage((Resource)this.getCurrentRevision());
                    throw new BundleException(Msg.Module_ResolveError + reportMessage, 4);
                }
            }
            this.setState(Module.State.STARTING);
            this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STARTING);
            try {
                this.initWorker();
            }
            catch (Throwable t) {
                this.setState(Module.State.STOPPING);
                this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STOPPING);
                this.setState(Module.State.RESOLVED);
                this.publishEvent(ModuleContainerAdaptor.ModuleEvent.STOPPED);
                this.getRevisions().getContainer().close();
                if (t instanceof BundleException) {
                    throw (BundleException)t;
                }
                throw new BundleException("Error initializing container.", 5, t);
            }
        }
        finally {
            this.getContainer().getAdaptor().initEnd();
            if (lockedStarted) {
                this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.STARTED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleContainerAdaptor.ContainerEvent waitForStop(long timeout) throws InterruptedException {
        ModuleContainerAdaptor.ContainerEvent containerEvent;
        boolean stateLocked;
        boolean waitForever = timeout == 0L;
        long start = System.currentTimeMillis();
        Thread current = Thread.currentThread();
        long timeLeft = timeout;
        ModuleContainerAdaptor.ContainerEvent event = null;
        if (timeout == 0L) {
            this.stateChangeLock.lockInterruptibly();
            stateLocked = true;
        } else {
            stateLocked = this.stateChangeLock.tryLock(timeLeft, TimeUnit.MILLISECONDS);
        }
        if (stateLocked) {
            Map<Thread, ModuleContainerAdaptor.ContainerEvent> map = this.forStop;
            synchronized (map) {
                try {
                    if (!Module.ACTIVE_SET.contains((Object)this.getState())) {
                        ModuleContainerAdaptor.ContainerEvent containerEvent2 = ModuleContainerAdaptor.ContainerEvent.STOPPED;
                        return containerEvent2;
                    }
                    event = this.forStop.remove(current);
                    if (event == null) {
                        this.forStop.put(current, null);
                    }
                }
                finally {
                    this.stateChangeLock.unlock();
                }
                long l = timeLeft = waitForever ? 0L : start + timeout - System.currentTimeMillis();
                while (event == null && (waitForever || timeLeft > 0L)) {
                    this.forStop.wait(timeLeft);
                    event = this.forStop.remove(current);
                    if (waitForever) continue;
                    timeLeft = start + timeout - System.currentTimeMillis();
                }
            }
        }
        if (event == null) {
            containerEvent = ModuleContainerAdaptor.ContainerEvent.STOPPED_TIMEOUT;
            return containerEvent;
        }
        containerEvent = event;
        return containerEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitForStop(ModuleContainerAdaptor.ContainerEvent event) {
        Map<Thread, ModuleContainerAdaptor.ContainerEvent> map = this.forStop;
        synchronized (map) {
            ArrayList<Thread> waiting = new ArrayList<Thread>(this.forStop.keySet());
            for (Thread t : waiting) {
                this.forStop.put(t, event);
            }
            this.forStop.notifyAll();
        }
    }

    protected void initWorker() throws BundleException {
    }

    @Override
    public void start(Module.StartOptions ... options) throws BundleException {
        this.init();
        super.start(Module.StartOptions.TRANSIENT, Module.StartOptions.USE_ACTIVATION_POLICY);
        this.getRevisions().getContainer().adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.STARTED, this, null, new FrameworkListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Module.StopOptions ... options) throws BundleException {
        ModuleContainerAdaptor.ContainerEvent containerEvent;
        block8: {
            containerEvent = ModuleContainerAdaptor.ContainerEvent.STOPPED_TIMEOUT;
            try {
                if (this.stateChangeLock.tryLock(10L, TimeUnit.SECONDS)) {
                    try {
                        try {
                            super.stop(Module.StopOptions.TRANSIENT);
                        }
                        catch (BundleException e) {
                            this.getRevisions().getContainer().adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, this, e, new FrameworkListener[0]);
                        }
                        containerEvent = this.holdsTransitionEventLock(ModuleContainerAdaptor.ModuleEvent.UPDATED) ? ModuleContainerAdaptor.ContainerEvent.STOPPED_UPDATE : (this.holdsTransitionEventLock(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED) ? ModuleContainerAdaptor.ContainerEvent.STOPPED_REFRESH : ModuleContainerAdaptor.ContainerEvent.STOPPED);
                        this.getRevisions().getContainer().adaptor.publishContainerEvent(containerEvent, this, null, new FrameworkListener[0]);
                        this.getRevisions().getContainer().close();
                        break block8;
                    }
                    finally {
                        this.stateChangeLock.unlock();
                    }
                }
                throw new BundleException(Msg.SystemModule_LockError);
            }
            catch (InterruptedException e) {
                this.getRevisions().getContainer().adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, this, e, new FrameworkListener[0]);
            }
        }
        this.notifyWaitForStop(containerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws BundleException {
        Module.State previousState;
        this.getContainer().checkAdminPermission(this.getBundle(), "lifecycle");
        this.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UPDATED);
        try {
            previousState = this.getState();
            this.stop(new Module.StopOptions[0]);
        }
        finally {
            this.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UPDATED);
        }
        switch (previousState) {
            case STARTING: {
                this.init();
                break;
            }
            case ACTIVE: {
                this.start(new Module.StartOptions[0]);
            }
        }
    }

    @Override
    protected void startWorker() throws BundleException {
        super.startWorker();
        ((ModuleContainer.ContainerStartLevel)this.getRevisions().getContainer().getFrameworkStartLevel()).doContainerStartLevel(this, Integer.MIN_VALUE, new FrameworkListener[0]);
    }

    @Override
    protected void stopWorker() throws BundleException {
        super.stopWorker();
        ((ModuleContainer.ContainerStartLevel)this.getRevisions().getContainer().getFrameworkStartLevel()).doContainerStartLevel(this, 0, new FrameworkListener[0]);
    }
}

