/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.EquinoxClassLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;

public class SystemBundleLoader
extends BundleLoader {
    public static final String EQUINOX_EE = "x-equinox-ee";
    final ClassLoader classLoader;
    final ModuleClassLoader moduleClassLoader;

    public SystemBundleLoader(ModuleWiring wiring, EquinoxContainer container, ClassLoader frameworkLoader) {
        super(wiring, container, frameworkLoader.getParent());
        this.classLoader = frameworkLoader;
        this.moduleClassLoader = new SystemModuleClassLoader(this.classLoader.getParent(), container.getConfiguration(), this, (BundleInfo.Generation)wiring.getRevision().getRevisionInfo());
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.findLocalClass(name);
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    @Override
    public Class<?> findLocalClass(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public URL findLocalResource(String name) {
        return this.classLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> findLocalResources(String name) {
        try {
            return this.classLoader.getResources(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public URL findResource(String name) {
        return this.findLocalResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.findLocalResources(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ModuleClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    @Override
    void loadClassLoaderFragments(Collection<ModuleRevision> fragments) {
        this.moduleClassLoader.loadFragments(fragments);
    }

    class SystemModuleClassLoader
    extends EquinoxClassLoader {
        public SystemModuleClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
            super(parent, configuration, delegate, generation);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return SystemBundleLoader.this.findClass(name);
        }

        @Override
        public void loadFragments(Collection<ModuleRevision> fragments) {
            Module systemModule = SystemBundleLoader.this.getWiring().getRevision().getRevisions().getModule();
            for (ModuleRevision fragment : fragments) {
                try {
                    this.getGeneration().getBundleInfo().getStorage().getExtensionInstaller().addExtensionContent(fragment, SystemBundleLoader.this.getWiring().getRevision().getRevisions().getModule());
                }
                catch (BundleException e) {
                    systemModule.getContainer().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, systemModule, e, new FrameworkListener[0]);
                }
            }
            this.getClasspathManager().loadFragments(fragments);
        }
    }
}

