/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.osgi.internal.log.EventAdminAdapter;
import org.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory;
import org.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import org.eclipse.osgi.internal.log.ExtendedLogServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class LogServiceManager
implements BundleListener,
FrameworkListener,
ServiceListener {
    private static final String[] LOGSERVICE_CLASSES = new String[]{LogService.class.getName(), ExtendedLogService.class.getName()};
    private static final String[] LOGREADERSERVICE_CLASSES = new String[]{LogReaderService.class.getName(), ExtendedLogReaderService.class.getName()};
    private ServiceRegistration<?> logReaderServiceRegistration;
    private ServiceRegistration<?> logServiceRegistration;
    private final ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private final ExtendedLogServiceFactory logServiceFactory;
    private final ExtendedLogServiceImpl systemBundleLog;
    private EventAdminAdapter eventAdminAdapter;

    public LogServiceManager(int maxHistory, LogListener ... systemListeners) {
        this.logReaderServiceFactory = new ExtendedLogReaderServiceFactory(maxHistory);
        this.logServiceFactory = new ExtendedLogServiceFactory(this.logReaderServiceFactory);
        this.systemBundleLog = this.logServiceFactory.getLogService(new MockSystemBundle());
        for (LogListener logListener : systemListeners) {
            if (logListener instanceof LogFilter) {
                this.logReaderServiceFactory.addLogListener(logListener, (LogFilter)logListener);
                continue;
            }
            this.logReaderServiceFactory.addLogListener(logListener, ExtendedLogReaderServiceFactory.NULL_LOGGER_FILTER);
        }
    }

    public void start(BundleContext context) {
        this.systemBundleLog.setBundle(context.getBundle());
        context.addBundleListener((BundleListener)this);
        context.addServiceListener((ServiceListener)this);
        context.addFrameworkListener((FrameworkListener)this);
        context.addBundleListener((BundleListener)this.logServiceFactory);
        this.logReaderServiceRegistration = context.registerService(LOGREADERSERVICE_CLASSES, (Object)this.logReaderServiceFactory, null);
        this.logServiceRegistration = context.registerService(LOGSERVICE_CLASSES, (Object)this.logServiceFactory, null);
        this.eventAdminAdapter = new EventAdminAdapter(context, this.logReaderServiceFactory);
        this.eventAdminAdapter.start();
    }

    public void stop(BundleContext context) {
        this.eventAdminAdapter.stop();
        this.eventAdminAdapter = null;
        this.logServiceRegistration.unregister();
        this.logServiceRegistration = null;
        this.logReaderServiceRegistration.unregister();
        this.logReaderServiceRegistration = null;
        this.logServiceFactory.shutdown();
        context.removeFrameworkListener((FrameworkListener)this);
        context.removeServiceListener((ServiceListener)this);
        context.removeBundleListener((BundleListener)this);
    }

    public ExtendedLogService getSystemBundleLog() {
        return this.systemBundleLog;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        if (this.logReaderServiceFactory.isLoggable(bundle, null, 3)) {
            this.logReaderServiceFactory.log(bundle, null, null, 3, LogServiceManager.getBundleEventTypeName(event.getType()), null);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        int logType;
        ServiceReference reference = event.getServiceReference();
        Bundle bundle = reference.getBundle();
        int eventType = event.getType();
        int n = logType = eventType == 2 ? 4 : 3;
        if (this.logReaderServiceFactory.isLoggable(bundle, null, logType)) {
            this.logReaderServiceFactory.log(bundle, null, reference, logType, LogServiceManager.getServiceEventTypeName(eventType), null);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        Throwable throwable;
        Bundle bundle = event.getBundle();
        int eventType = event.getType();
        int logType = eventType == 2 ? 1 : 3;
        Throwable throwable2 = throwable = eventType == 2 ? event.getThrowable() : null;
        if (this.logReaderServiceFactory.isLoggable(bundle, null, logType)) {
            this.logReaderServiceFactory.log(bundle, null, null, logType, LogServiceManager.getFrameworkEventTypeName(eventType), throwable);
        }
    }

    private static String getBundleEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "BundleEvent INSTALLED";
            }
            case 32: {
                return "BundleEvent RESOLVED";
            }
            case 2: {
                return "BundleEvent STARTED";
            }
            case 128: {
                return "BundleEvent STARTING";
            }
            case 4: {
                return "BundleEvent STOPPED";
            }
            case 256: {
                return "BundleEvent STOPPING";
            }
            case 16: {
                return "BundleEvent UNINSTALLED";
            }
            case 64: {
                return "BundleEvent UNRESOLVED";
            }
            case 8: {
                return "BundleEvent UPDATED";
            }
        }
        return "BundleEvent " + Integer.toHexString(type);
    }

    private static String getServiceEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "ServiceEvent REGISTERED";
            }
            case 2: {
                return "ServiceEvent MODIFIED";
            }
            case 4: {
                return "ServiceEvent UNREGISTERING";
            }
        }
        return "ServiceEvent " + Integer.toHexString(type);
    }

    private static String getFrameworkEventTypeName(int type) {
        switch (type) {
            case 2: {
                return "FrameworkEvent ERROR";
            }
            case 32: {
                return "FrameworkEvent INFO";
            }
            case 4: {
                return "FrameworkEvent PACKAGES REFRESHED";
            }
            case 1: {
                return "FrameworkEvent STARTED";
            }
            case 8: {
                return "FrameworkEvent STARTLEVEL CHANGED";
            }
            case 16: {
                return "FrameworkEvent WARNING";
            }
        }
        return "FrameworkEvent " + Integer.toHexString(type);
    }

    static class MockSystemBundle
    implements Bundle {
        MockSystemBundle() {
        }

        public int compareTo(Bundle o) {
            long idcomp = this.getBundleId() - o.getBundleId();
            return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
        }

        public int getState() {
            return 4;
        }

        public void start(int options) {
        }

        public void start() {
        }

        public void stop(int options) {
        }

        public void stop() {
        }

        public void update(InputStream input) {
        }

        public void update() {
        }

        public void uninstall() {
        }

        public Dictionary<String, String> getHeaders() {
            return new Hashtable<String, String>();
        }

        public long getBundleId() {
            return 0L;
        }

        public String getLocation() {
            return "System Bundle";
        }

        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return true;
        }

        public URL getResource(String name) {
            return null;
        }

        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        public String getSymbolicName() {
            return "org.eclipse.osgi";
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }

        public Enumeration<URL> getResources(String name) {
            return null;
        }

        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            return null;
        }

        public BundleContext getBundleContext() {
            return null;
        }

        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return new HashMap<X509Certificate, List<X509Certificate>>();
        }

        public Version getVersion() {
            return new Version(0, 0, 0);
        }

        public <A> A adapt(Class<A> type) {
            return null;
        }

        public File getDataFile(String filename) {
            return null;
        }
    }
}

